/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import java.util.List;
import java.util.stream.Collectors;
import mage.MageObject;
import mage.abilities.AbilityImpl;
import mage.cards.Card;
import mage.cards.decks.DeckCardInfo;
import mage.cards.mock.MockCard;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.constants.Zone;
import mage.game.command.Emblem;
import mage.util.CardUtil;

public final class EmblemOfCard
extends Emblem {
    public static Card lookupCard(String cardName, String cardNumber, String setCode, String infoTypeForError) {
        int intCardNumber = CardUtil.parseCardNumberAsInt(cardNumber);
        List<CardInfo> found = CardRepository.instance.findCards(new CardCriteria().name(cardName).minCardNumber(intCardNumber).maxCardNumber(intCardNumber).setCodes(setCode));
        return found.stream().filter(ci -> ci.getCardNumber().equals(cardNumber)).findFirst().orElseGet(() -> (CardInfo)found.stream().findFirst().orElseThrow(() -> new IllegalArgumentException("No real card for " + infoTypeForError + " " + cardName))).createCard();
    }

    public static Card cardFromDeckInfo(DeckCardInfo info) {
        return EmblemOfCard.lookupCard(info.getCardName(), info.getCardNumber(), info.getSetCode(), "DeckCardInfo");
    }

    public EmblemOfCard(Card card, Zone zone) {
        super(card.getName());
        if (card instanceof MockCard) {
            card = EmblemOfCard.lookupCard(card.getName(), card.getCardNumber(), card.getExpansionSetCode(), "MockCard");
        }
        this.getAbilities().addAll(card.getAbilities().stream().filter(ability -> zone.match(ability.getZone())).map(ability -> {
            if (ability instanceof AbilityImpl && ability.getZone() == zone) {
                return ((AbilityImpl)ability).copyWithZone(Zone.COMMAND);
            }
            return ability;
        }).collect(Collectors.toList()));
        this.getAbilities().setSourceId(this.getId());
        this.setExpansionSetCode(card.getExpansionSetCode());
        this.setUsesVariousArt(card.getUsesVariousArt());
        this.setCardNumber(card.getCardNumber());
        this.setImageFileName(card.getImageFileName());
        this.setImageNumber(card.getImageNumber());
    }

    public EmblemOfCard(Card card) {
        this(card, Zone.BATTLEFIELD);
    }

    private EmblemOfCard(EmblemOfCard eoc) {
        super(eoc);
    }

    @Override
    public EmblemOfCard copy() {
        return new EmblemOfCard(this);
    }

    @Override
    public void setSourceObjectAndInitImage(MageObject sourceObject) {
        this.sourceObject = sourceObject;
    }
}

