/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import java.util.LinkedHashSet;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardsImpl;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class KayaTheInexorableEmblemEffect
extends OneShotEffect {
    private static final FilterCard filter2 = new FilterCard();
    private static final Set<String> choices = new LinkedHashSet<String>();

    public KayaTheInexorableEmblemEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "cast a legendary spell from your hand, from your graveyard, or from among cards you own in exile without paying its mana cost";
    }

    private KayaTheInexorableEmblemEffect(KayaTheInexorableEmblemEffect effect) {
        super(effect);
    }

    @Override
    public KayaTheInexorableEmblemEffect copy() {
        return new KayaTheInexorableEmblemEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ChoiceImpl zoneChoice = new ChoiceImpl(true);
        zoneChoice.setMessage("Cast a legendary spell from hand, graveyard, or exile");
        zoneChoice.setChoices(choices);
        zoneChoice.clearChoice();
        player.choose(Outcome.PlayForFree, zoneChoice, game);
        CardsImpl cards = new CardsImpl();
        switch (zoneChoice.getChoice()) {
            case "Hand": {
                cards.addAll(player.getHand());
                break;
            }
            case "Graveyard": {
                cards.addAll(player.getGraveyard());
                break;
            }
            case "Exile": {
                cards.addAllCards(game.getExile().getCardsOwned(game, player.getId()));
            }
        }
        return CardUtil.castSpellWithAttributesForFree(player, source, game, cards, filter2);
    }

    static {
        filter2.add(SuperType.LEGENDARY.getPredicate());
        choices.add("Hand");
        choices.add("Graveyard");
        choices.add("Exile");
    }
}

