/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeTargetEffect;
import mage.abilities.effects.common.continuous.AddCardTypeTargetEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessTargetEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

class TezzeretCruelCaptainEmblemEffect
extends OneShotEffect {
    TezzeretCruelCaptainEmblemEffect() {
        super(Outcome.Benefit);
        this.staticText = "If it's not a creature, it becomes a 0/0 Robot artifact creature";
    }

    private TezzeretCruelCaptainEmblemEffect(TezzeretCruelCaptainEmblemEffect effect) {
        super(effect);
    }

    @Override
    public TezzeretCruelCaptainEmblemEffect copy() {
        return new TezzeretCruelCaptainEmblemEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null || permanent.isCreature(game)) {
            return false;
        }
        game.addEffect(new AddCardTypeTargetEffect(Duration.Custom, CardType.ARTIFACT, CardType.CREATURE).setTargetPointer(new FixedTarget(permanent, game)), source);
        game.addEffect(new AddCardSubTypeTargetEffect(SubType.ROBOT, Duration.Custom).setTargetPointer(new FixedTarget(permanent, game)), source);
        game.addEffect(new SetBasePowerToughnessTargetEffect(0, 0, Duration.Custom).setTargetPointer(new FixedTarget(permanent, game)), source);
        return true;
    }
}

