/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheRingEmblemEvasionEffect
extends RestrictionEffect {
    TheRingEmblemEvasionEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "and can't be blocked by creatures with greater power";
    }

    private TheRingEmblemEvasionEffect(TheRingEmblemEvasionEffect effect) {
        super(effect);
    }

    @Override
    public TheRingEmblemEvasionEffect copy() {
        return new TheRingEmblemEvasionEffect(this);
    }

    @Override
    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.isControlledBy(source.getControllerId()) && permanent.isRingBearer();
    }

    @Override
    public boolean canBeBlocked(Permanent attacker, Permanent blocker, Ability source, Game game, boolean canUseChooseDialogs) {
        return blocker.getPower().getValue() <= attacker.getPower().getValue();
    }
}

