/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class TheRingEmblemLegendaryEffect
extends ContinuousEffectImpl {
    TheRingEmblemLegendaryEffect() {
        super(Duration.WhileOnBattlefield, Layer.TypeChangingEffects_4, SubLayer.NA, Outcome.Benefit);
        this.staticText = "your Ring-bearer is legendary";
    }

    private TheRingEmblemLegendaryEffect(TheRingEmblemLegendaryEffect effect) {
        super(effect);
    }

    @Override
    public TheRingEmblemLegendaryEffect copy() {
        return new TheRingEmblemLegendaryEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Permanent permanent = Optional.ofNullable(game.getPlayer(source.getControllerId())).map(player -> player.getRingBearer(game)).orElse(null);
        if (permanent == null) {
            return false;
        }
        permanent.addSuperType(game, SuperType.LEGENDARY);
        return true;
    }
}

