/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.emblems;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.common.delayed.AtTheEndOfCombatDelayedTriggeredAbility;
import mage.abilities.effects.common.CreateDelayedTriggeredAbilityEffect;
import mage.abilities.effects.common.SacrificeTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;

class TheRingEmblemTriggeredAbility
extends TriggeredAbilityImpl {
    TheRingEmblemTriggeredAbility() {
        super(Zone.COMMAND, new CreateDelayedTriggeredAbilityEffect(new AtTheEndOfCombatDelayedTriggeredAbility(new SacrificeTargetEffect())));
    }

    private TheRingEmblemTriggeredAbility(TheRingEmblemTriggeredAbility ability) {
        super(ability);
    }

    @Override
    public TheRingEmblemTriggeredAbility copy() {
        return new TheRingEmblemTriggeredAbility(this);
    }

    @Override
    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.BLOCKER_DECLARED;
    }

    @Override
    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attacker = game.getPermanent(event.getTargetId());
        Permanent blocker = game.getPermanent(event.getSourceId());
        if (attacker == null || blocker == null || !attacker.isControlledBy(this.getControllerId()) || !attacker.isRingBearer()) {
            return false;
        }
        this.getEffects().setTargetPointer(new FixedTarget(blocker, game));
        return true;
    }

    @Override
    public String getRule() {
        return "Whenever your Ring-bearer becomes blocked by a creature, that creature's controller sacrifices it at end of combat.";
    }
}

