/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import java.util.ArrayList;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.MainPhaseStackEmptyCondition;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.RollPlanarDieEffect;
import mage.abilities.effects.common.continuous.CastAsThoughItHadFlashAllEffect;
import mage.abilities.effects.common.cost.PlanarDieRollCostIncreasingEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Planes;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.EnchantedPredicate;
import mage.game.command.Plane;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.watchers.common.PlanarRollWatcher;

public class AkoumPlane
extends Plane {
    private static final FilterCard filterCard = new FilterCard("enchantment spells");
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("creature that isn't enchanted");

    public AkoumPlane() {
        this.setPlaneType(Planes.PLANE_AKOUM);
        SimpleStaticAbility ability = new SimpleStaticAbility(Zone.COMMAND, new CastAsThoughItHadFlashAllEffect(Duration.Custom, filterCard, true));
        this.getAbilities().add(ability);
        DestroyTargetEffect chaosEffect = new DestroyTargetEffect("destroy target creature that isn't enchanted");
        TargetPermanent chaosTarget = new TargetPermanent(filter);
        ArrayList<Effect> chaosEffects = new ArrayList<Effect>();
        chaosEffects.add(chaosEffect);
        ArrayList<Target> chaosTargets = new ArrayList<Target>();
        chaosTargets.add(chaosTarget);
        ActivateIfConditionActivatedAbility chaosAbility = new ActivateIfConditionActivatedAbility(Zone.COMMAND, new RollPlanarDieEffect(chaosEffects, chaosTargets), new GenericManaCost(0), MainPhaseStackEmptyCondition.instance);
        chaosAbility.addWatcher(new PlanarRollWatcher());
        this.getAbilities().add(chaosAbility);
        chaosAbility.setMayActivate(TargetController.ANY);
        this.getAbilities().add(new SimpleStaticAbility(Zone.ALL, new PlanarDieRollCostIncreasingEffect(chaosAbility.getOriginalId())));
    }

    private AkoumPlane(AkoumPlane plane) {
        super(plane);
    }

    @Override
    public AkoumPlane copy() {
        return new AkoumPlane(this);
    }

    static {
        filter.add(Predicates.not(EnchantedPredicate.instance));
        filterCard.add(CardType.ENCHANTMENT.getPredicate());
    }
}

