/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import java.util.ArrayList;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.MainPhaseStackEmptyCondition;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageAllEffect;
import mage.abilities.effects.common.RollPlanarDieEffect;
import mage.abilities.effects.common.cost.PlanarDieRollCostIncreasingEffect;
import mage.constants.Planes;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.command.Plane;
import mage.game.command.planes.AstralArenaAttackRestrictionEffect;
import mage.game.command.planes.AstralArenaBlockRestrictionEffect;
import mage.target.Target;
import mage.watchers.common.AttackedThisTurnWatcher;
import mage.watchers.common.PlanarRollWatcher;

public class AstralArenaPlane
extends Plane {
    public AstralArenaPlane() {
        this.setPlaneType(Planes.PLANE_ASTRAL_ARENA);
        SimpleStaticAbility ability = new SimpleStaticAbility(Zone.COMMAND, new AstralArenaAttackRestrictionEffect());
        ability.addWatcher(new AttackedThisTurnWatcher());
        SimpleStaticAbility ability2 = new SimpleStaticAbility(Zone.COMMAND, new AstralArenaBlockRestrictionEffect());
        ability2.addWatcher(new AttackedThisTurnWatcher());
        this.getAbilities().add(ability);
        this.getAbilities().add(ability2);
        DamageAllEffect chaosEffect = new DamageAllEffect(2, (FilterPermanent)new FilterCreaturePermanent());
        Object chaosTarget = null;
        ArrayList<Effect> chaosEffects = new ArrayList<Effect>();
        chaosEffects.add(chaosEffect);
        ArrayList<Target> chaosTargets = new ArrayList<Target>();
        chaosTargets.add((Target)chaosTarget);
        ActivateIfConditionActivatedAbility chaosAbility = new ActivateIfConditionActivatedAbility(Zone.COMMAND, new RollPlanarDieEffect(chaosEffects, chaosTargets), new GenericManaCost(0), MainPhaseStackEmptyCondition.instance);
        chaosAbility.addWatcher(new PlanarRollWatcher());
        this.getAbilities().add(chaosAbility);
        chaosAbility.setMayActivate(TargetController.ANY);
        this.getAbilities().add(new SimpleStaticAbility(Zone.ALL, new PlanarDieRollCostIncreasingEffect(chaosAbility.getOriginalId())));
    }

    private AstralArenaPlane(AstralArenaPlane plane) {
        super(plane);
    }

    @Override
    public AstralArenaPlane copy() {
        return new AstralArenaPlane(this);
    }
}

