/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import mage.MageObject;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Planes;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.game.command.Plane;
import mage.game.stack.Spell;
import mage.util.CardUtil;

class FeedingGroundsEffect
extends CostModificationEffectImpl {
    private static final FilterCard filter = new FilterCard("Red spells or Green spells");
    private static final String rule = "Red spells cost {1} less to cast. Green spells cost {1} less to cast";
    private int amount = 1;

    public FeedingGroundsEffect() {
        super(Duration.Custom, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.amount = 1;
        this.staticText = rule;
    }

    protected FeedingGroundsEffect(FeedingGroundsEffect effect) {
        super(effect);
        this.amount = effect.amount;
    }

    @Override
    public void init(Ability source, Game game) {
        super.init(source, game);
    }

    @Override
    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        MageObject object = abilityToModify.getSourceObject(game);
        int reduce = 0;
        if (object != null) {
            if (object.getColor(game).isRed()) {
                ++reduce;
            }
            if (object.getColor(game).isGreen()) {
                ++reduce;
            }
        }
        CardUtil.reduceCost(abilityToModify, reduce);
        return true;
    }

    protected boolean selectedByRuntimeData(Card card, Ability source, Game game) {
        return true;
    }

    @Override
    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        if (abilityToModify instanceof SpellAbility) {
            Plane cPlane = game.getState().getCurrentPlane();
            if (cPlane == null) {
                return false;
            }
            if (!cPlane.getPlaneType().equals((Object)Planes.PLANE_FEEDING_GROUNDS)) {
                return false;
            }
            Spell spell = (Spell)game.getStack().getStackObject(abilityToModify.getId());
            if (spell != null) {
                return filter.match(spell, game) && this.selectedByRuntimeData(spell, source, game);
            }
            Card sourceCard = game.getCard(abilityToModify.getSourceId());
            return filter.match(sourceCard, game) && this.selectedByRuntimeData(sourceCard, source, game);
        }
        return false;
    }

    @Override
    public FeedingGroundsEffect copy() {
        return new FeedingGroundsEffect(this);
    }

    static {
        filter.add(Predicates.or(new ColorPredicate(ObjectColor.RED), new ColorPredicate(ObjectColor.GREEN)));
    }
}

