/*
 * Decompiled with CFR 0.152.
 */
package mage.game.command.planes;

import java.util.ArrayList;
import mage.abilities.common.ActivateIfConditionActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.common.MainPhaseStackEmptyCondition;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.DrawCardTargetEffect;
import mage.abilities.effects.common.RollPlanarDieEffect;
import mage.abilities.effects.common.cost.PlanarDieRollCostIncreasingEffect;
import mage.abilities.triggers.BeginningOfDrawTriggeredAbility;
import mage.constants.Planes;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.command.Plane;
import mage.game.command.planes.PanopticonTriggeredAbility;
import mage.target.Target;
import mage.watchers.common.PlanarRollWatcher;

public class PanopticonPlane
extends Plane {
    private static final String rule = "At the beginning of your draw step, draw an additional card";

    public PanopticonPlane() {
        this.setPlaneType(Planes.PLANE_PANOPTICON);
        PanopticonTriggeredAbility pwability = new PanopticonTriggeredAbility(new DrawCardTargetEffect(1));
        this.getAbilities().add(pwability);
        BeginningOfDrawTriggeredAbility ability = new BeginningOfDrawTriggeredAbility(Zone.COMMAND, TargetController.YOU, new DrawCardTargetEffect(1), false);
        this.getAbilities().add(ability);
        DrawCardSourceControllerEffect chaosEffect = new DrawCardSourceControllerEffect(1);
        Object chaosTarget = null;
        ArrayList<Effect> chaosEffects = new ArrayList<Effect>();
        chaosEffects.add(chaosEffect);
        ArrayList<Target> chaosTargets = new ArrayList<Target>();
        chaosTargets.add((Target)chaosTarget);
        ActivateIfConditionActivatedAbility chaosAbility = new ActivateIfConditionActivatedAbility(Zone.COMMAND, new RollPlanarDieEffect(chaosEffects, chaosTargets), new GenericManaCost(0), MainPhaseStackEmptyCondition.instance);
        chaosAbility.addWatcher(new PlanarRollWatcher());
        this.getAbilities().add(chaosAbility);
        chaosAbility.setMayActivate(TargetController.ANY);
        this.getAbilities().add(new SimpleStaticAbility(Zone.ALL, new PlanarDieRollCostIncreasingEffect(chaosAbility.getOriginalId())));
    }

    private PanopticonPlane(PanopticonPlane plane) {
        super(plane);
    }

    @Override
    public PanopticonPlane copy() {
        return new PanopticonPlane(this);
    }
}

