/*
 * Decompiled with CFR 0.152.
 */
package mage.game.draft;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.players.Player;

public class DraftPlayer {
    protected UUID id = UUID.randomUUID();
    protected Player player;
    protected Deck deck;
    protected List<Card> booster;
    protected boolean picking;
    protected boolean boosterLoaded;
    protected boolean joined = false;
    protected Set<UUID> hiddenCards;

    public DraftPlayer(Player player) {
        this.player = player;
        this.deck = new Deck();
        this.hiddenCards = new HashSet<UUID>();
    }

    public UUID getId() {
        return this.id;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void prepareDeck() {
        if (!this.hiddenCards.isEmpty()) {
            HashSet<Card> cardsToDeck = new HashSet<Card>();
            for (Card card : this.deck.getSideboard()) {
                if (this.hiddenCards.contains(card.getId())) continue;
                cardsToDeck.add(card);
            }
            for (Card card : cardsToDeck) {
                this.deck.getSideboard().remove(card);
                this.deck.getCards().add(card);
            }
        }
    }

    public Deck getDeck() {
        return this.deck;
    }

    public void addPick(Card card, Set<UUID> hiddenCards) {
        this.deck.getSideboard().add(card);
        if (hiddenCards != null) {
            this.hiddenCards = hiddenCards;
        }
        this.booster.remove(card);
        this.picking = false;
    }

    public void setBoosterAndLoad(List<Card> booster) {
        this.booster = booster;
        this.boosterLoaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Card> getBooster() {
        if (this.booster == null) {
            return null;
        }
        List<Card> list = this.booster;
        synchronized (list) {
            return new ArrayList<Card>(this.booster);
        }
    }

    public void setPickingAndSending() {
        this.picking = true;
        this.boosterLoaded = false;
    }

    public boolean isPicking() {
        return this.picking;
    }

    public boolean isJoined() {
        return this.joined;
    }

    public void setJoined() {
        this.joined = true;
    }

    public void setBoosterLoaded() {
        this.boosterLoaded = true;
    }

    public void setBoosterNotLoaded() {
        this.boosterLoaded = false;
    }

    public boolean isBoosterLoaded() {
        return this.boosterLoaded;
    }
}

