/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mage.game.events.ExternalEvent;
import mage.game.events.Listener;

public abstract class EventDispatcher<E extends ExternalEvent>
implements Serializable {
    private final List<Listener<E>> listeners = new CopyOnWriteArrayList<Listener<E>>();

    public void addListener(Listener<E> listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(Listener<E> listener) {
        this.listeners.remove(listener);
    }

    public void fireEvent(E event) {
        for (Listener<E> listener : this.listeners) {
            listener.event(event);
        }
    }

    public void removeAllListener() {
        this.listeners.clear();
    }
}

