/*
 * Decompiled with CFR 0.152.
 */
package mage.game.events;

import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.RollDieType;
import mage.game.events.GameEvent;
import mage.util.CardUtil;

public class RollDiceEvent
extends GameEvent {
    private final int sides;
    private int ignoreLowestAmount = 0;
    private final RollDieType rollDieType;

    public RollDiceEvent(Ability source, UUID targetId, RollDieType rollDieType, int sides, int rollsAmount) {
        super(GameEvent.EventType.ROLL_DICE, targetId, source, source.getControllerId(), rollsAmount, false);
        this.sides = sides;
        this.rollDieType = rollDieType;
    }

    public int getSides() {
        return this.sides;
    }

    public RollDieType getRollDieType() {
        return this.rollDieType;
    }

    public void incAmount(int additionalAmount) {
        this.amount = CardUtil.overflowInc(this.amount, additionalAmount);
    }

    public void incIgnoreLowestAmount(int additionalCount) {
        this.ignoreLowestAmount = CardUtil.overflowInc(this.ignoreLowestAmount, additionalCount);
    }

    public int getIgnoreLowestAmount() {
        return this.ignoreLowestAmount;
    }
}

