/*
 * Decompiled with CFR 0.152.
 */
package mage.game.match;

import java.io.Serializable;
import mage.cards.Card;
import mage.cards.decks.Deck;
import mage.cards.decks.DeckValidator;
import mage.game.match.Match;
import mage.players.Player;
import org.apache.log4j.Logger;

public class MatchPlayer
implements Serializable {
    private static final Logger logger = Logger.getLogger(MatchPlayer.class);
    private int wins;
    private int winsNeeded;
    private boolean matchWinner;
    private Deck deck;
    private final Player player;
    private final String name;
    private boolean quit;
    private boolean doneSideboarding;
    private int priorityTimeLeft;

    public MatchPlayer(Player player, Deck deck, Match match) {
        this.player = player;
        this.deck = deck;
        this.wins = 0;
        this.winsNeeded = match.getWinsNeeded();
        this.doneSideboarding = true;
        this.quit = false;
        this.name = player.getName();
        this.matchWinner = false;
    }

    public MatchPlayer(MatchPlayer source, Player newPlayer) {
        this.wins = source.wins;
        this.winsNeeded = source.winsNeeded;
        this.matchWinner = source.matchWinner;
        this.deck = source.deck;
        this.player = newPlayer;
        this.name = newPlayer.getName();
        this.quit = source.quit;
        this.doneSideboarding = source.doneSideboarding;
        this.priorityTimeLeft = source.priorityTimeLeft;
    }

    public int getPriorityTimeLeft() {
        return this.priorityTimeLeft;
    }

    public void setPriorityTimeLeft(int priorityTimeLeft) {
        this.priorityTimeLeft = priorityTimeLeft;
    }

    public int getWins() {
        return this.wins;
    }

    public int getWinsNeeded() {
        return this.winsNeeded;
    }

    public void addWin() {
        ++this.wins;
    }

    public Deck getDeck() {
        return this.deck;
    }

    public Deck getDeckForViewer() {
        if (this.deck == null) {
            return null;
        }
        Deck viewerDeck = this.deck.copy();
        viewerDeck.setName(this.getName());
        return viewerDeck;
    }

    public void submitDeck(Deck newDeck) {
        this.deck = newDeck;
        this.doneSideboarding = true;
    }

    public boolean updateDeck(Deck newDeck, boolean ignoreMainBasicLands) {
        boolean isGood;
        if (this.deck != null) {
            newDeck.setName(this.getDeck().getName());
        }
        boolean bl = isGood = this.deck.getDeckHash(ignoreMainBasicLands) == newDeck.getDeckHash(ignoreMainBasicLands);
        if (!isGood) {
            logger.error((Object)("Found cheating player " + this.player.getName() + " with changed deck, main " + newDeck.getCards().size() + ", side " + newDeck.getSideboard().size()));
            newDeck.getCards().clear();
            newDeck.getSideboard().clear();
        }
        this.deck = newDeck;
        return isGood;
    }

    public Deck autoCompleteDeck(DeckValidator deckValidator) {
        while (this.deck.getMaindeckCards().size() < deckValidator.getDeckMinSize() && !this.deck.getSideboard().isEmpty()) {
            Card card = this.deck.getSideboard().iterator().next();
            this.deck.getCards().add(card);
            this.deck.getSideboard().remove(card);
        }
        return this.deck;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setSideboarding() {
        this.doneSideboarding = false;
    }

    public boolean isDoneSideboarding() {
        return this.doneSideboarding;
    }

    public boolean hasQuit() {
        return this.quit;
    }

    public void setQuit(boolean quit) {
        this.doneSideboarding = true;
        this.quit = quit;
    }

    public boolean isMatchWinner() {
        return this.matchWinner;
    }

    public void setMatchWinner(boolean matchWinner) {
        this.matchWinner = matchWinner;
    }

    public void cleanUpOnMatchEnd() {
        this.deck = null;
        this.player.cleanUpOnMatchEnd();
    }

    public String getName() {
        return this.name;
    }
}

