/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.GameState;
import mage.util.CardUtil;

public interface Permanent
extends Card,
Controllable {
    public void setOriginalControllerId(UUID var1);

    public void setControllerId(UUID var1);

    public boolean isTapped();

    public boolean untap(Game var1);

    public boolean tap(Ability var1, Game var2);

    public boolean tap(boolean var1, Ability var2, Game var3);

    public void setTapped(boolean var1);

    public boolean canTap(Game var1);

    public boolean isFlipped();

    public boolean flip(Game var1);

    public boolean transform(Ability var1, Game var2);

    public boolean transform(Ability var1, Game var2, boolean var3);

    public boolean isTransformed();

    public void setTransformed(boolean var1);

    public int getTransformCount();

    public boolean isPhasedIn();

    public boolean isPhasedOutIndirectly();

    public boolean phaseIn(Game var1);

    public boolean phaseIn(Game var1, boolean var2);

    public boolean phaseOut(Game var1);

    public boolean phaseOut(Game var1, boolean var2);

    public boolean isMonstrous();

    public void setMonstrous(boolean var1);

    public boolean isRenowned();

    public void setRenowned(boolean var1);

    public boolean isSuspected();

    public void setSuspected(boolean var1, Game var2, Ability var3);

    public boolean isPrototyped();

    public void setPrototyped(boolean var1);

    public int getClassLevel();

    public boolean setClassLevel(int var1);

    public void addGoadingPlayer(UUID var1);

    public Set<UUID> getGoadingPlayers();

    public void chooseProtector(Game var1, Ability var2);

    public void setProtectorId(UUID var1);

    public UUID getProtectorId();

    public boolean isProtectedBy(UUID var1);

    public void setCanBeSacrificed(boolean var1);

    public boolean canBeSacrificed();

    @Override
    public void setCardNumber(String var1);

    @Override
    public void setExpansionSetCode(String var1);

    public void setFlipCard(boolean var1);

    public void setFlipCardName(String var1);

    public void setSecondCardFace(Card var1);

    @Override
    public List<UUID> getAttachments();

    public UUID getAttachedTo();

    public int getAttachedToZoneChangeCounter();

    public void attachTo(UUID var1, Ability var2, Game var3);

    public void unattach(Game var1);

    public boolean canBeTargetedBy(MageObject var1, UUID var2, Ability var3, Game var4);

    public boolean hasProtectionFrom(MageObject var1, Game var2);

    public boolean wasControlledFromStartOfControllerTurn();

    public boolean hasSummoningSickness();

    public int getDamage();

    public int damage(int var1, Ability var2, Game var3);

    public int damage(int var1, UUID var2, Ability var3, Game var4);

    public int damage(int var1, UUID var2, Ability var3, Game var4, boolean var5, boolean var6);

    public int damage(int var1, UUID var2, Ability var3, Game var4, boolean var5, boolean var6, List<UUID> var7);

    public int markDamage(int var1, UUID var2, Ability var3, Game var4, boolean var5, boolean var6);

    public void markLifelink(int var1);

    public int applyDamage(Game var1);

    public int getLethalDamage(UUID var1, Game var2);

    default public int damageWithExcess(int damage, Ability source, Game game) {
        return this.damageWithExcess(damage, source.getSourceId(), source, game);
    }

    default public int damageWithExcess(int damage, UUID attackerId, Ability source, Game game) {
        int lethal = this.getLethalDamage(attackerId, game);
        int excess = Math.max(CardUtil.overflowDec(damage, lethal), 0);
        int dealt = Math.min(lethal, damage);
        this.damage(dealt, attackerId, source, game);
        return excess;
    }

    public void removeAllDamage(Game var1);

    public void reset(Game var1);

    public MageObject getBasicMageObject();

    public boolean destroy(Ability var1, Game var2);

    public boolean destroy(Ability var1, Game var2, boolean var3);

    public boolean sacrifice(Ability var1, Game var2);

    public boolean regenerate(Ability var1, Game var2);

    public boolean fight(Permanent var1, Ability var2, Game var3);

    public boolean fight(Permanent var1, Ability var2, Game var3, boolean var4);

    public boolean entersBattlefield(Ability var1, Game var2, Zone var3, boolean var4);

    public String getValue(GameState var1);

    public Ability addAbility(Ability var1, UUID var2, Game var3);

    public Ability addAbility(Ability var1, UUID var2, Game var3, boolean var4);

    public void removeAllAbilities(UUID var1, Game var2);

    public void removeAbility(Ability var1, UUID var2, Game var3);

    public void removeAbilities(List<Ability> var1, UUID var2, Game var3);

    public void incrementLoyaltyActivationsAvailable();

    public void incrementLoyaltyActivationsAvailable(int var1);

    public void setLoyaltyActivationsAvailable(int var1);

    public void addLoyaltyUsed();

    public boolean canLoyaltyBeUsed(Game var1);

    public void setLegendRuleApplies(boolean var1);

    public boolean legendRuleApplies();

    public void resetControl();

    public boolean changeControllerId(UUID var1, Game var2, Ability var3);

    public boolean checkControlChanged(Game var1);

    public void beginningOfTurn(Game var1);

    public void endOfTurn(Game var1);

    public int getTurnsOnBattlefield();

    public void addPower(int var1);

    public void addToughness(int var1);

    public boolean isAttacking();

    public boolean isBlocked(Game var1);

    public int getBlocking();

    public void setAttacking(boolean var1);

    public void setBlocking(int var1);

    public int getMaxBlocks();

    public void setMaxBlocks(int var1);

    public int getMinBlockedBy();

    public void setMinBlockedBy(int var1);

    public int getMaxBlockedBy();

    public void setMaxBlockedBy(int var1);

    public boolean canAttack(UUID var1, Game var2);

    public boolean canAttackInPrinciple(UUID var1, Game var2);

    public boolean canBlock(UUID var1, Game var2);

    public boolean canBlockAny(Game var1);

    public boolean canBeAttacked(UUID var1, UUID var2, Game var3);

    public boolean canUseActivatedAbilities(Game var1);

    public boolean removeFromCombat(Game var1);

    public boolean removeFromCombat(Game var1, boolean var2);

    public boolean isDeathtouched();

    public Set<MageObjectReference> getDealtDamageByThisTurn();

    public boolean imprint(UUID var1, Game var2);

    public boolean clearImprinted(Game var1);

    public List<UUID> getImprinted();

    public void addConnectedCard(String var1, UUID var2);

    public List<UUID> getConnectedCards(String var1);

    public void clearConnectedCards(String var1);

    public void setPairedCard(MageObjectReference var1);

    public MageObjectReference getPairedCard();

    public void clearPairedCard();

    public void addBandedCard(UUID var1);

    public void removeBandedCard(UUID var1);

    public List<UUID> getBandedCards();

    public void clearBandedCards();

    public void setMorphed(boolean var1);

    public boolean isMorphed();

    public void setDisguised(boolean var1);

    public boolean isDisguised();

    public void setManifested(boolean var1);

    public boolean isManifested();

    public void setCloaked(boolean var1);

    public boolean isCloaked();

    public boolean isRingBearer();

    public void setRingBearer(Game var1, boolean var2);

    public boolean isSolved();

    public boolean solve(Game var1, Ability var2);

    public boolean isHarnessed();

    public void setHarnessed(boolean var1);

    @Override
    public Permanent copy();

    public int getCreateOrder();

    public void setCreateOrder(int var1);

    default public boolean isAttachedTo(UUID otherId) {
        if (this.getAttachedTo() == null) {
            return false;
        }
        return this.getAttachedTo().equals(otherId);
    }

    default public void switchPowerToughness() {
        int power = this.getPower().getValue();
        this.getPower().setBoostedValue(this.getToughness().getValue());
        this.getToughness().setBoostedValue(power);
    }
}

