/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.keyword.NightboundAbility;
import mage.abilities.keyword.TransformAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.cards.LevelerCard;
import mage.cards.ModalDoubleFacedCard;
import mage.cards.SplitCard;
import mage.constants.SpellAbilityType;
import mage.game.Game;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentImpl;
import mage.players.Player;

public class PermanentCard
extends PermanentImpl {
    protected Card card;
    protected int maxLevelCounters;
    protected int zoneChangeCounter;

    public PermanentCard(Card card, UUID controllerId, Game game) {
        super(card.getId(), card.getOwnerId(), controllerId, card.getName());
        if (card instanceof PermanentCard) {
            throw new IllegalArgumentException("Wrong code usage: can't use PermanentCard inside another PermanentCard");
        }
        boolean goodForBattlefield = true;
        if (card instanceof ModalDoubleFacedCard) {
            goodForBattlefield = false;
        } else if (card instanceof SplitCard && card.getSpellAbility() != null && !card.getSpellAbility().getSpellAbilityType().equals((Object)SpellAbilityType.SPLIT_FUSED)) {
            goodForBattlefield = false;
        }
        if (card.isFaceDown(game)) {
            goodForBattlefield = true;
        }
        if (!goodForBattlefield) {
            throw new IllegalArgumentException("Wrong code usage: can't create permanent card from split or mdf: " + card.getName());
        }
        this.card = card;
        this.zoneChangeCounter = card.getZoneChangeCounter(game);
        this.init(card, game);
    }

    private void init(Card card, Game game) {
        this.power = card.getPower().copy();
        this.toughness = card.getToughness().copy();
        this.startingLoyalty = card.getStartingLoyalty();
        this.startingDefense = card.getStartingDefense();
        this.copyFromCard(card, game);
        Abilities<Ability> otherAbilities = game.getState().getAllOtherAbilities(card.getId());
        if (otherAbilities != null) {
            this.abilities.addAll(otherAbilities);
        }
        if (card instanceof LevelerCard) {
            this.maxLevelCounters = ((LevelerCard)card).getMaxLevelCounters();
        }
        if (card.isTransformable() && (game.getState().getValue("EnterTransformed" + this.getId()) != null || NightboundAbility.checkCard(this, game))) {
            game.getState().setValue("EnterTransformed" + this.getId(), null);
            TransformAbility.transformPermanent(this, game, null);
        }
    }

    protected PermanentCard(PermanentCard permanent) {
        super(permanent);
        this.card = permanent.card.copy();
        this.maxLevelCounters = permanent.maxLevelCounters;
        this.zoneChangeCounter = permanent.zoneChangeCounter;
    }

    @Override
    public void reset(Game game) {
        this.copyFromCard(this.card, game);
        this.power.resetToBaseValue();
        this.toughness.resetToBaseValue();
        super.reset(game);
    }

    protected void copyFromCard(Card card, Game game) {
        this.name = card.getName();
        this.abilities.clear();
        if (this.faceDown) {
            for (Ability ability : card.getAbilities()) {
                if (!ability.getWorksFaceDown()) continue;
                this.abilities.add(ability.copy());
            }
        } else {
            this.abilities = card.getAbilities().copy();
            this.spellAbility = null;
        }
        this.abilities.setControllerId(this.controllerId);
        this.abilities.setSourceId(this.objectId);
        this.cardType.clear();
        this.cardType.addAll(card.getCardType());
        this.color = card.getColor(game).copy();
        this.frameColor = card.getFrameColor(game).copy();
        this.frameStyle = card.getFrameStyle();
        this.manaCost = card.getManaCost().copy();
        if (card instanceof PermanentCard) {
            this.maxLevelCounters = ((PermanentCard)card).maxLevelCounters;
        }
        this.subtype.copyFrom(card.getSubtype());
        this.supertype.clear();
        this.supertype.addAll(card.getSuperType());
        this.rarity = card.getRarity();
        this.setExpansionSetCode(card.getExpansionSetCode());
        this.setUsesVariousArt(card.getUsesVariousArt());
        this.setCardNumber(card.getCardNumber());
        this.setImageFileName(card.getImageFileName());
        this.setImageNumber(card.getImageNumber());
        if (card.getSecondCardFace() != null) {
            this.secondSideCardClazz = card.getSecondCardFace().getClass();
        }
        if (card.getMeldsToCard() != null) {
            this.meldsToClazz = card.getMeldsToCard().getClass();
        }
        this.nightCard = card.isNightCard();
        this.flipCard = card.isFlipCard();
        this.flipCardName = card.getFlipCardName();
    }

    @Override
    public MageObject getBasicMageObject() {
        return this.card;
    }

    public Card getCard() {
        return this.card;
    }

    @Override
    public PermanentCard copy() {
        return new PermanentCard(this);
    }

    public int getMaxLevelCounters() {
        return this.maxLevelCounters;
    }

    @Override
    public boolean turnFaceUp(Ability source, Game game, UUID playerId) {
        if (!this.getBasicMageObject().isPermanent()) {
            Player player = game.getPlayer(source.getControllerId());
            if (player != null) {
                player.revealCards(source, (Cards)new CardsImpl(this), game);
            }
            return false;
        }
        if (super.turnFaceUp(source, game, playerId)) {
            this.power.setModifiedBaseValue(this.power.getBaseValue());
            this.toughness.setModifiedBaseValue(this.toughness.getBaseValue());
            this.setManifested(false);
            this.setMorphed(false);
            this.setDisguised(false);
            this.setCloaked(false);
            return true;
        }
        return false;
    }

    @Override
    public ManaCosts<ManaCost> getManaCost() {
        if (this.faceDown) {
            this.manaCost.clear();
            return this.manaCost;
        }
        return super.getManaCost();
    }

    @Override
    public int getManaValue() {
        if (this.isTransformed()) {
            return this.getCard().getManaValue();
        }
        if (this.faceDown) {
            return this.getManaCost().manaValue();
        }
        return super.getManaValue();
    }

    @Override
    public int getZoneChangeCounter(Game game) {
        return this.zoneChangeCounter;
    }

    @Override
    public void updateZoneChangeCounter(Game game, ZoneChangeEvent event) {
        this.card.updateZoneChangeCounter(game, event);
        this.zoneChangeCounter = this.card.getZoneChangeCounter(game);
    }

    @Override
    public void setZoneChangeCounter(int value, Game game) {
        this.card.setZoneChangeCounter(value, game);
    }

    @Override
    public Card getMainCard() {
        return this.card.getMainCard();
    }
}

