/*
 * Decompiled with CFR 0.152.
 */
package mage.game.permanent.token;

import mage.abilities.common.AttacksTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.SourceMatchesFilterCondition;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.continuous.GainAbilityAttachedEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.game.permanent.token.TokenImpl;
import mage.target.common.TargetCreaturePermanent;

public final class YoungHeroRoleToken
extends TokenImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("its toughness is 3 or less");
    private static final Condition condition;

    public YoungHeroRoleToken() {
        super("Young Hero", "Young Hero Role token");
        this.cardType.add(CardType.ENCHANTMENT);
        this.subtype.add(SubType.AURA);
        this.subtype.add(SubType.ROLE);
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        EnchantAbility ability = new EnchantAbility(auraTarget);
        ability.addTarget(auraTarget);
        ability.addEffect(new AttachEffect(Outcome.BoostCreature));
        this.addAbility(ability);
        this.addAbility(new SimpleStaticAbility(new GainAbilityAttachedEffect(new AttacksTriggeredAbility(new AddCountersSourceEffect(CounterType.P1P1.createInstance()).setText("put a +1/+1 counter on it")).withInterveningIf(condition), AttachmentType.AURA)));
    }

    private YoungHeroRoleToken(YoungHeroRoleToken token) {
        super(token);
    }

    @Override
    public YoungHeroRoleToken copy() {
        return new YoungHeroRoleToken(this);
    }

    static {
        filter.add(new ToughnessPredicate(ComparisonType.FEWER_THAN, 4));
        condition = new SourceMatchesFilterCondition(filter);
    }
}

