/*
 * Decompiled with CFR 0.152.
 */
package mage.game.stack;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.MageObject;
import mage.abilities.AbilitiesImpl;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.choices.Choice;
import mage.choices.ChoiceHintType;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.MageObjectReferencePredicate;
import mage.game.Game;
import mage.game.events.CopyStackObjectEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetAmount;
import mage.util.CardUtil;
import mage.util.functions.StackObjectCopyApplier;

public abstract class StackObjectImpl
implements StackObject {
    protected boolean targetChanged;

    @Override
    public void createCopyOnStack(Game game, Ability source, UUID newControllerId, boolean chooseNewTargets) {
        this.createCopyOnStack(game, source, newControllerId, chooseNewTargets, 1);
    }

    @Override
    public void createCopyOnStack(Game game, Ability source, UUID newControllerId, boolean chooseNewTargets, int amount) {
        this.createCopyOnStack(game, source, newControllerId, chooseNewTargets, amount, null);
    }

    @Override
    public void createCopyOnStack(Game game, Ability source, UUID newControllerId, boolean chooseNewTargets, int amount, StackObjectCopyApplier applier) {
        if (!this.canBeCopied()) {
            return;
        }
        CopyStackObjectEvent gameEvent = new CopyStackObjectEvent(source, this, newControllerId, amount);
        if (game.replaceEvent(gameEvent)) {
            return;
        }
        NewTargetTypeIterator newTargetTypeIterator = new NewTargetTypeIterator(game, newControllerId, gameEvent.getAmount(), applier);
        for (int i = 0; i < gameEvent.getAmount(); ++i) {
            this.createSingleCopy(newControllerId, applier, (MageObjectReferencePredicate)newTargetTypeIterator.next(), game, source, chooseNewTargets);
        }
        Player player = game.getPlayer(newControllerId);
        if (player == null) {
            return;
        }
        game.informPlayers(player.getName() + " created " + CardUtil.numberToText(gameEvent.getAmount(), "a") + " cop" + (gameEvent.getAmount() == 1 ? "y" : "ies") + " of " + this.getIdName());
    }

    public boolean chooseNewTargets(Game game, UUID playerId) {
        return this.chooseNewTargets(game, playerId, false, false, null);
    }

    @Override
    public boolean chooseNewTargets(Game game, UUID targetControllerId, boolean forceChange, boolean onlyOneTarget, Predicate<MageItem> newTargetFilterPredicate) {
        Player targetController = game.getPlayer(targetControllerId);
        if (targetController != null) {
            StringBuilder oldTargetDescription = new StringBuilder();
            StringBuilder newTargetDescription = new StringBuilder();
            AbilitiesImpl objectAbilities = new AbilitiesImpl();
            if (this instanceof Spell) {
                objectAbilities.addAll(((Spell)this).getSpellAbilities());
            } else {
                objectAbilities.add(this.getStackAbility());
            }
            for (Ability ability : objectAbilities) {
                for (UUID modeId : ability.getModes().getSelectedModes()) {
                    Mode mode = ability.getModes().get(modeId);
                    ability.getModes().setActiveMode(mode);
                    oldTargetDescription.append(ability.getTargetDescription(mode.getTargets(), game));
                    for (Target target : mode.getTargets()) {
                        Target newTarget = this.chooseNewTarget(targetController, ability, mode, target, forceChange, newTargetFilterPredicate, game);
                        target.clearChosen();
                        for (UUID targetId : newTarget.getTargets()) {
                            target.addTarget(targetId, newTarget.getTargetAmount(targetId), ability, game, false);
                        }
                    }
                    newTargetDescription.append(ability.getTargetDescription(mode.getTargets(), game));
                }
            }
            if (!newTargetDescription.toString().equals(oldTargetDescription.toString()) && !game.isSimulation()) {
                game.informPlayers(this.getLogName() + " is now " + newTargetDescription);
            }
            return true;
        }
        return false;
    }

    private Target chooseNewTarget(Player targetController, Ability ability, Mode mode, Target target, boolean forceChange, Predicate newTargetFilterPredicate, Game game) {
        Target newTarget = target.copy();
        newTarget.clearChosen();
        if (newTargetFilterPredicate != null) {
            newTarget.getFilter().add(newTargetFilterPredicate);
            newTarget.setRandom(true);
        }
        newTarget.setEventReporting(false);
        if (!targetController.getId().equals(this.getControllerId())) {
            newTarget.setTargetController(targetController.getId());
            newTarget.setAbilityController(this.getControllerId());
        }
        int targetNumber = 0;
        for (UUID oldTargetId : target.getTargets()) {
            ++targetNumber;
            String targetName = this.getNameOftarget(oldTargetId, game);
            String targetAmount = "";
            if (target.getTargetAmount(oldTargetId) > 0) {
                targetAmount = " (amount: " + target.getTargetAmount(oldTargetId) + ")";
            }
            Outcome outcome = mode.getEffects().getOutcome(ability);
            if (targetName != null && (forceChange || targetController.chooseUse(outcome, String.format("Change this %d of %d target: %s?", targetNumber, target.getTargets().size(), targetName + targetAmount), ability, game))) {
                boolean again;
                Set<UUID> possibleTargets = newTarget.possibleTargets(this.getControllerId(), ability, game);
                if (forceChange && possibleTargets != null && possibleTargets.size() > 1) {
                    int iteration = 0;
                    do {
                        if (iteration > 0 && !game.isSimulation()) {
                            game.informPlayer(targetController, "You may only select exactly one target that must be different from the origin target!");
                        }
                        newTarget.clearChosen();
                        newTarget.chooseTarget(outcome, this.getControllerId(), ability, game);
                    } while (++iteration <= 10 && targetController.canRespond() && (oldTargetId.equals(newTarget.getFirstTarget()) || newTarget.getTargets().size() != 1));
                    continue;
                }
                Target tempTarget = target.copy();
                if (newTargetFilterPredicate != null) {
                    tempTarget.getFilter().add(newTargetFilterPredicate);
                    tempTarget.setRandom(true);
                }
                tempTarget.setEventReporting(false);
                if (target instanceof TargetAmount) {
                    ((TargetAmount)tempTarget).setAmountDefinition(StaticValue.get(target.getTargetAmount(oldTargetId)));
                }
                tempTarget.setMinNumberOfTargets(1);
                tempTarget.setMaxNumberOfTargets(1);
                if (!targetController.getId().equals(this.getControllerId())) {
                    tempTarget.setTargetController(targetController.getId());
                    tempTarget.setAbilityController(this.getControllerId());
                }
                do {
                    again = false;
                    tempTarget.clearChosen();
                    if (!tempTarget.chooseTarget(outcome, this.getControllerId(), ability, game)) {
                        if (targetController.chooseUse(Outcome.Benefit, "No target object selected. Reset to original target?", ability, game)) {
                            newTarget.addTarget(oldTargetId, target.getTargetAmount(oldTargetId), ability, game, true);
                            continue;
                        }
                        again = true;
                        continue;
                    }
                    if (newTarget.getTargets().contains(tempTarget.getFirstTarget()) || target.getTargets().contains(tempTarget.getFirstTarget())) {
                        if (targetController.isHuman()) {
                            if (targetController.chooseUse(Outcome.Benefit, "This target was already selected from origin spell. Reset to original target?", ability, game)) {
                                newTarget.addTarget(oldTargetId, target.getTargetAmount(oldTargetId), ability, game, true);
                                continue;
                            }
                            again = true;
                            continue;
                        }
                        newTarget.addTarget(oldTargetId, target.getTargetAmount(oldTargetId), ability, game, true);
                        continue;
                    }
                    if (!target.canTarget(this.getControllerId(), tempTarget.getFirstTarget(), ability, game)) {
                        if (targetController.isHuman()) {
                            game.informPlayer(targetController, "This target is not valid!");
                            again = true;
                            continue;
                        }
                        newTarget.addTarget(oldTargetId, target.getTargetAmount(oldTargetId), ability, game, true);
                        continue;
                    }
                    newTarget.addTarget(tempTarget.getFirstTarget(), target.getTargetAmount(oldTargetId), ability, game, true);
                } while (again && targetController.canRespond());
                continue;
            }
            newTarget.addTarget(oldTargetId, target.getTargetAmount(oldTargetId), ability, game, true);
        }
        return newTarget;
    }

    @Override
    public boolean canTarget(Game game, UUID targetId) {
        AbilitiesImpl objectAbilities = new AbilitiesImpl();
        if (this instanceof Spell) {
            objectAbilities.addAll(((Spell)this).getSpellAbilities());
        } else {
            objectAbilities.add(this.getStackAbility());
        }
        for (Ability ability : objectAbilities) {
            if (!ability.getModes().getSelectedModes().stream().map(ability.getModes()::get).filter(Objects::nonNull).map(Mode::getTargets).flatMap(Collection::stream).filter(t -> !t.isNotTarget()).anyMatch(t -> t.canTarget(ability.getControllerId(), targetId, ability, game))) continue;
            return true;
        }
        return false;
    }

    private String getNameOftarget(UUID targetId, Game game) {
        Player targetPlayer = game.getPlayer(targetId);
        if (targetPlayer != null) {
            return targetPlayer.getLogName();
        }
        MageObject object = game.getObject(targetId);
        if (object != null) {
            return object.getIdName();
        }
        return null;
    }

    @Override
    public void removePTCDA() {
    }

    @Override
    public boolean isTargetChanged() {
        return this.targetChanged;
    }

    @Override
    public void setTargetChanged(boolean targetChanged) {
        this.targetChanged = targetChanged;
    }

    private static final class NewTargetTypeIterator
    implements Iterator<MageObjectReferencePredicate> {
        private final StackObjectCopyApplier applier;
        private final Player player;
        private final int amount;
        private final Game game;
        private Map<String, MageObjectReferencePredicate> newTargetTypes = null;
        private Iterator<MageObjectReferencePredicate> currentNewTargetType = null;
        private Choice newTargetTypeChoiceDialog = null;

        private NewTargetTypeIterator(Game game, UUID newControllerId, int amount, StackObjectCopyApplier applier) {
            this.applier = applier;
            this.player = game.getPlayer(newControllerId);
            this.amount = amount;
            this.game = game;
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        private void prepareNewTargetTypes() {
            if (this.newTargetTypes != null) {
                return;
            }
            int currentAnyTargetNumber = 0;
            int currentFilteredTargetNumber = 0;
            this.newTargetTypes = new HashMap<String, MageObjectReferencePredicate>();
            for (int i = 0; i < this.amount; ++i) {
                MageObjectReferencePredicate newTargetType = this.applier.getNextNewTargetType();
                if (newTargetType == null) {
                    String message = "Any target";
                    if (++currentAnyTargetNumber > 1) {
                        message = message + " (" + currentAnyTargetNumber + ")";
                    }
                    this.newTargetTypes.put(message, null);
                    continue;
                }
                ++currentFilteredTargetNumber;
                this.newTargetTypes.put(newTargetType.getName(this.game), newTargetType);
            }
            if (currentFilteredTargetNumber == 1 && currentAnyTargetNumber == 0 || currentFilteredTargetNumber == 0) {
                this.currentNewTargetType = this.newTargetTypes.values().stream().collect(Collectors.toList()).iterator();
            }
        }

        private void prepareFilterChooseDialog() {
            if (this.newTargetTypeChoiceDialog != null) {
                return;
            }
            this.newTargetTypeChoiceDialog = new ChoiceImpl(false, ChoiceHintType.CARD);
            this.newTargetTypeChoiceDialog.setMessage("Choose the order of copies to go on the stack");
            this.newTargetTypeChoiceDialog.setSubMessage("Press cancel to put the rest in any order");
            this.newTargetTypeChoiceDialog.setChoices(new HashSet<String>(this.newTargetTypes.keySet()));
        }

        @Override
        public MageObjectReferencePredicate next() {
            if (this.player == null || this.applier == null) {
                return null;
            }
            this.prepareNewTargetTypes();
            if (this.currentNewTargetType != null) {
                return this.currentNewTargetType.hasNext() ? this.currentNewTargetType.next() : null;
            }
            this.prepareFilterChooseDialog();
            if (this.newTargetTypeChoiceDialog.getChoices().size() < 2) {
                this.currentNewTargetType = this.newTargetTypeChoiceDialog.getChoices().stream().map(this.newTargetTypes::get).iterator();
                return this.next();
            }
            this.newTargetTypeChoiceDialog.clearChoice();
            this.player.choose(Outcome.AIDontUseIt, this.newTargetTypeChoiceDialog, this.game);
            String chosen = this.newTargetTypeChoiceDialog.getChoice();
            if (chosen == null) {
                this.currentNewTargetType = this.newTargetTypeChoiceDialog.getChoices().stream().map(this.newTargetTypes::get).iterator();
                return this.next();
            }
            this.newTargetTypeChoiceDialog.getChoices().remove(chosen);
            return this.newTargetTypes.get(chosen);
        }
    }
}

