/*
 * Decompiled with CFR 0.152.
 */
package mage.game.tournament;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.game.tournament.Tournament;
import mage.game.tournament.TournamentPairing;
import mage.game.tournament.TournamentPlayer;
import mage.game.tournament.TournamentSingleElimination;

public class Round {
    private final int roundNum;
    private final Tournament tournament;
    private final List<TournamentPairing> pairs = new ArrayList<TournamentPairing>();
    private final List<TournamentPlayer> playerByes = new ArrayList<TournamentPlayer>();

    public Round(int roundNum, Tournament tournament) {
        this.roundNum = roundNum;
        this.tournament = tournament;
    }

    public void addPairing(TournamentPairing match) {
        this.pairs.add(match);
    }

    public TournamentPairing getPairing(UUID pairId) {
        for (TournamentPairing pair : this.pairs) {
            if (!pair.getId().equals(pairId)) continue;
            return pair;
        }
        return null;
    }

    public List<TournamentPairing> getPairs() {
        return this.pairs;
    }

    public int getRoundNumber() {
        return this.roundNum;
    }

    public boolean isRoundOver() {
        boolean roundIsOver = true;
        for (TournamentPairing pair : this.pairs) {
            if (pair.getMatch() == null) continue;
            if (!pair.getMatch().hasEnded()) {
                roundIsOver = false;
                continue;
            }
            if (pair.isAlreadyPublished()) continue;
            this.tournament.updateResults();
            pair.setAlreadyPublished(true);
            if (this.tournament instanceof TournamentSingleElimination) {
                pair.eliminatePlayers();
            }
            if (this.getRoundNumber() != this.tournament.getNumberRounds()) continue;
            pair.finishPlayersThatPlayedLastRound();
        }
        return roundIsOver;
    }

    public List<TournamentPlayer> getPlayerByes() {
        return this.playerByes;
    }
}

