/*
 * Decompiled with CFR 0.152.
 */
package mage.game.tournament;

import java.util.UUID;
import mage.constants.TournamentPlayerState;
import mage.game.match.Match;
import mage.game.match.MatchPlayer;
import mage.game.tournament.TournamentPlayer;

public class TournamentPairing {
    private final UUID id = UUID.randomUUID();
    private UUID tableId;
    private Match match;
    private final TournamentPlayer player1;
    private final TournamentPlayer player2;
    private boolean alreadyPublished;

    public TournamentPairing(TournamentPlayer player1, TournamentPlayer player2) {
        this.player1 = player1;
        this.player2 = player2;
        this.alreadyPublished = false;
    }

    public UUID getId() {
        return this.id;
    }

    public TournamentPlayer getPlayer1() {
        return this.player1;
    }

    public TournamentPlayer getPlayer2() {
        return this.player2;
    }

    public Match getMatch() {
        return this.match;
    }

    public void setMatchAndTable(Match match, UUID tableId) {
        this.match = match;
        this.tableId = tableId;
    }

    public void eliminatePlayers() {
        if (this.match != null && this.match.hasEnded()) {
            MatchPlayer mPlayer1 = this.match.getPlayer(this.player1.getPlayer().getId());
            MatchPlayer mPlayer2 = this.match.getPlayer(this.player2.getPlayer().getId());
            if (mPlayer1.hasQuit() || !mPlayer1.isMatchWinner()) {
                this.player1.setEliminated();
            }
            if (mPlayer2.hasQuit() || !mPlayer2.isMatchWinner()) {
                this.player2.setEliminated();
            }
        }
    }

    public void finishPlayersThatPlayedLastRound() {
        if (this.match != null && this.match.hasEnded()) {
            if (!this.player1.isEliminated()) {
                this.player1.setEliminated();
                this.player1.setState(TournamentPlayerState.FINISHED);
            }
            if (!this.player2.isEliminated()) {
                this.player2.setEliminated();
                this.player2.setState(TournamentPlayerState.FINISHED);
            }
        }
    }

    public void eliminateComputer() {
        if (!this.player1.getPlayer().isHuman()) {
            this.player1.setEliminated();
            return;
        }
        if (!this.player2.getPlayer().isHuman()) {
            this.player2.setEliminated();
        }
    }

    public UUID getTableId() {
        return this.tableId;
    }

    public boolean isAlreadyPublished() {
        return this.alreadyPublished;
    }

    public void setAlreadyPublished(boolean alreadyPublished) {
        this.alreadyPublished = alreadyPublished;
    }
}

