/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.util.UUID;
import mage.abilities.common.SagaAbility;
import mage.constants.PhaseStep;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.turn.Step;

public class PreCombatMainStep
extends Step {
    private static final FilterPermanent filter = new FilterPermanent("Saga");

    public PreCombatMainStep() {
        super(PhaseStep.PRECOMBAT_MAIN, true);
        this.stepEvent = GameEvent.EventType.PRECOMBAT_MAIN_STEP;
        this.preStepEvent = GameEvent.EventType.PRECOMBAT_MAIN_STEP_PRE;
        this.postStepEvent = GameEvent.EventType.PRECOMBAT_MAIN_STEP_POST;
    }

    private PreCombatMainStep(PreCombatMainStep step) {
        super(step);
    }

    @Override
    public void beginStep(Game game, UUID activePlayerId) {
        super.beginStep(game, activePlayerId);
        for (Permanent saga : game.getBattlefield().getAllActivePermanents(filter, activePlayerId, game)) {
            if (saga == null) continue;
            saga.addCounters(CounterType.LORE.createInstance(), activePlayerId, null, game);
        }
    }

    @Override
    public PreCombatMainStep copy() {
        return new PreCombatMainStep(this);
    }

    static {
        filter.add(SubType.SAGA.getPredicate());
        filter.add(new AbilityPredicate(SagaAbility.class));
    }
}

