/*
 * Decompiled with CFR 0.152.
 */
package mage.game.turn;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.UUID;
import mage.constants.PhaseStep;
import mage.constants.TurnPhase;
import mage.game.turn.TurnMod;
import mage.util.Copyable;

public class TurnMods
extends ArrayList<TurnMod>
implements Serializable,
Copyable<TurnMods> {
    public TurnMods() {
    }

    private TurnMods(TurnMods mods) {
        for (TurnMod mod : mods) {
            this.add(mod.copy());
        }
    }

    @Override
    public TurnMods copy() {
        return new TurnMods(this);
    }

    @Override
    public boolean add(TurnMod turnMod) {
        if (!turnMod.isLocked()) {
            throw new IllegalStateException("Wrong code usage: you must prepare turn mode with modification");
        }
        return super.add(turnMod);
    }

    public TurnMod useNextExtraTurn() {
        ListIterator it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            TurnMod turnMod = (TurnMod)it.previous();
            if (!turnMod.isExtraTurn()) continue;
            it.remove();
            return turnMod;
        }
        return null;
    }

    public TurnMod useNextSkipTurn(UUID playerId) {
        ListIterator it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            TurnMod turnMod = (TurnMod)it.previous();
            if (!turnMod.isSkipTurn() || !turnMod.getPlayerId().equals(playerId)) continue;
            it.remove();
            return turnMod;
        }
        return null;
    }

    public TurnMod useNextNewController(UUID playerId) {
        TurnMod turnMod;
        TurnMod lastNewControllerMod = null;
        ListIterator it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            turnMod = (TurnMod)it.previous();
            if (turnMod.getNewControllerId() == null || !turnMod.getPlayerId().equals(playerId)) continue;
            lastNewControllerMod = turnMod;
            it.remove();
        }
        it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            turnMod = (TurnMod)it.previous();
            if (turnMod.getNewControllerId() == null || !turnMod.getPlayerId().equals(playerId)) continue;
            it.remove();
        }
        if (lastNewControllerMod != null && lastNewControllerMod.getSubsequentTurnMod() != null) {
            this.add(lastNewControllerMod.getSubsequentTurnMod());
        }
        return lastNewControllerMod;
    }

    public TurnMod useNextExtraStep(UUID playerId, PhaseStep afterStep) {
        ListIterator it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            TurnMod turnMod = (TurnMod)it.previous();
            if (turnMod.getExtraStep() == null || !turnMod.getPlayerId().equals(playerId) || turnMod.getAfterStep() != null && turnMod.getAfterStep() != afterStep) continue;
            it.remove();
            return turnMod;
        }
        return null;
    }

    public TurnMod useNextSkipStep(UUID playerId, PhaseStep step) {
        if (step != null) {
            ListIterator it = this.listIterator(this.size());
            while (it.hasPrevious()) {
                TurnMod turnMod = (TurnMod)it.previous();
                if (turnMod.getSkipStep() == null || turnMod.getPlayerId() == null || !turnMod.getPlayerId().equals(playerId) || turnMod.getSkipStep() != step) continue;
                it.remove();
                return turnMod;
            }
        }
        return null;
    }

    public TurnMod useNextExtraPhase(UUID playerId, TurnPhase afterPhase) {
        ListIterator it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            TurnMod turnMod = (TurnMod)it.previous();
            if (turnMod.getExtraPhase() == null || !turnMod.getPlayerId().equals(playerId) || turnMod.getAfterPhase() != null && turnMod.getAfterPhase() != afterPhase) continue;
            it.remove();
            return turnMod;
        }
        return null;
    }

    public TurnMod useNextSkipPhase(UUID playerId, TurnPhase phase) {
        ListIterator it = this.listIterator(this.size());
        while (it.hasPrevious()) {
            TurnMod turnMod = (TurnMod)it.previous();
            if (turnMod.getSkipPhase() == null || !turnMod.getPlayerId().equals(playerId) || turnMod.getSkipPhase() != phase) continue;
            it.remove();
            return turnMod;
        }
        return null;
    }
}

