/*
 * Decompiled with CFR 0.152.
 */
package mage.players;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.cards.Card;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.util.RandomUtil;

public class Library
implements Serializable {
    private boolean emptyDraw;
    private final Deque<UUID> library = new ArrayDeque<UUID>();
    private final UUID playerId;

    public Library(UUID playerId) {
        this.playerId = playerId;
    }

    protected Library(Library lib) {
        this.emptyDraw = lib.emptyDraw;
        this.playerId = lib.playerId;
        for (UUID id : lib.library) {
            this.library.addLast(id);
        }
    }

    public void shuffle() {
        UUID[] shuffled = this.library.toArray(new UUID[0]);
        for (int n = shuffled.length - 1; n > 0; --n) {
            int r = RandomUtil.nextInt(n + 1);
            UUID temp = shuffled[n];
            shuffled[n] = shuffled[r];
            shuffled[r] = temp;
        }
        this.library.clear();
        this.library.addAll(Arrays.asList(shuffled));
    }

    public Card drawFromTop(Game game) {
        Card card = game.getCard(this.library.pollFirst());
        if (card == null) {
            this.emptyDraw = true;
        }
        return card;
    }

    public Card drawFromBottom(Game game) {
        Card card = game.getCard(this.library.pollLast());
        if (card == null) {
            this.emptyDraw = true;
        }
        return card;
    }

    @Deprecated
    public Card removeFromTop(Game game) {
        return game.getCard(this.library.pollFirst());
    }

    public Card getFromTop(Game game) {
        return game.getCard(this.library.peekFirst());
    }

    public Card getFromBottom(Game game) {
        return game.getCard(this.library.peekLast());
    }

    public void putOnTop(Card card, Game game) {
        if (card.isOwnedBy(this.playerId)) {
            card.setZone(Zone.LIBRARY, game);
            this.library.remove(card.getId());
            this.library.addFirst(card.getId());
        } else {
            game.getPlayer(card.getOwnerId()).getLibrary().putOnTop(card, game);
        }
    }

    public void putCardToTopXPos(Card card, int pos, Game game) {
        if (card != null && pos > -1) {
            LinkedList<Card> save = new LinkedList<Card>();
            for (int idx = 1; this.hasCards() && idx < pos; ++idx) {
                save.add(this.removeFromTop(game));
            }
            this.putOnTop(card, game);
            while (!save.isEmpty()) {
                this.putOnTop((Card)save.removeLast(), game);
            }
        }
    }

    public void putOnBottom(Card card, Game game) {
        if (card.isOwnedBy(this.playerId)) {
            card.setZone(Zone.LIBRARY, game);
            this.library.remove(card.getId());
            this.library.add(card.getId());
        } else {
            game.getPlayer(card.getOwnerId()).getLibrary().putOnBottom(card, game);
        }
    }

    public Library copy() {
        return new Library(this);
    }

    public void clear() {
        this.library.clear();
    }

    public int size() {
        return this.library.size();
    }

    public List<UUID> getCardList() {
        return new ArrayList<UUID>(this.library);
    }

    public List<Card> getCards(Game game) {
        return this.library.stream().map(game::getCard).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Set<Card> getTopCards(Game game, int amount) {
        LinkedHashSet<Card> cards = new LinkedHashSet<Card>();
        Iterator<UUID> it = this.library.iterator();
        int count = 0;
        while (it.hasNext() && count < amount) {
            UUID cardId = it.next();
            Card card = game.getCard(cardId);
            if (card == null) continue;
            cards.add(card);
            ++count;
        }
        return cards;
    }

    public Collection<Card> getUniqueCards(Game game) {
        return this.getCards(game);
    }

    public int count(FilterCard filter, Game game) {
        return (int)this.library.stream().filter(cardId -> filter.match(game.getCard((UUID)cardId), game)).count();
    }

    public boolean isEmptyDraw() {
        return this.emptyDraw;
    }

    public void addAll(Set<Card> cards, Game game) {
        for (Card card : cards) {
            card.setZone(Zone.LIBRARY, game);
            this.library.remove(card.getId());
            this.library.add(card.getId());
        }
    }

    public Card getCard(UUID cardId, Game game) {
        for (UUID card : this.library) {
            if (!card.equals(cardId)) continue;
            return game.getCard(card);
        }
        return null;
    }

    public Card remove(UUID cardId, Game game) {
        Iterator<UUID> it = this.library.iterator();
        while (it.hasNext()) {
            UUID card = it.next();
            if (!card.equals(cardId)) continue;
            it.remove();
            return game.getCard(card);
        }
        return null;
    }

    public boolean hasCards() {
        return this.size() > 0;
    }

    public void reset() {
        this.emptyDraw = false;
    }

    public int getCardPosition(UUID cardId) {
        UUID[] list = this.library.toArray(new UUID[0]);
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(cardId)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return "Cards: " + this.library.size();
    }
}

