/*
 * Decompiled with CFR 0.152.
 */
package mage.players;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.ActivatedAbility;
import mage.abilities.PlayLandAbility;
import mage.abilities.SpellAbility;
import mage.abilities.mana.BasicManaAbility;
import mage.constants.SpellAbilityType;
import mage.players.PlayableObjectRecord;
import mage.util.Copyable;

public class PlayableObjectStats
implements Serializable,
Copyable<PlayableObjectStats> {
    List<PlayableObjectRecord> basicManaAbilities = new ArrayList<PlayableObjectRecord>();
    List<PlayableObjectRecord> basicPlayAbilities = new ArrayList<PlayableObjectRecord>();
    List<PlayableObjectRecord> basicCastAbilities = new ArrayList<PlayableObjectRecord>();
    List<PlayableObjectRecord> other = new ArrayList<PlayableObjectRecord>();

    public PlayableObjectStats() {
    }

    public PlayableObjectStats(List<ActivatedAbility> activatedAbilities) {
        this.load(activatedAbilities);
    }

    public void load(List<ActivatedAbility> activatedAbilities) {
        this.basicManaAbilities.clear();
        this.basicPlayAbilities.clear();
        this.basicCastAbilities.clear();
        this.other.clear();
        for (ActivatedAbility ability : activatedAbilities) {
            List<PlayableObjectRecord> dest = ability instanceof BasicManaAbility ? this.basicManaAbilities : (ability instanceof PlayLandAbility ? this.basicPlayAbilities : (ability instanceof SpellAbility && ((SpellAbility)ability).getSpellAbilityType() == SpellAbilityType.BASE ? this.basicCastAbilities : this.other));
            String shortInfo = ability.toString();
            shortInfo = shortInfo.replace("<br>", " ");
            if ((shortInfo = shortInfo.replace("\n", " ")).length() > 50) {
                shortInfo = shortInfo.substring(0, 49) + "...";
            }
            dest.add(new PlayableObjectRecord(ability.getId(), shortInfo));
        }
    }

    protected PlayableObjectStats(PlayableObjectStats source) {
        for (PlayableObjectRecord rec : source.basicManaAbilities) {
            this.basicManaAbilities.add(rec.copy());
        }
        for (PlayableObjectRecord rec : source.basicPlayAbilities) {
            this.basicPlayAbilities.add(rec.copy());
        }
        for (PlayableObjectRecord rec : source.basicCastAbilities) {
            this.basicCastAbilities.add(rec.copy());
        }
        for (PlayableObjectRecord rec : source.other) {
            this.other.add(rec.copy());
        }
    }

    @Override
    public PlayableObjectStats copy() {
        return new PlayableObjectStats(this);
    }

    public int getPlayableAmount() {
        return this.basicManaAbilities.size() + this.basicPlayAbilities.size() + this.basicCastAbilities.size() + this.other.size();
    }

    public List<String> getPlayableAbilityNames() {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(this.basicManaAbilities.stream().map(PlayableObjectRecord::getValue).sorted().collect(Collectors.toList()));
        all.addAll(this.basicPlayAbilities.stream().map(PlayableObjectRecord::getValue).sorted().collect(Collectors.toList()));
        all.addAll(this.basicCastAbilities.stream().map(PlayableObjectRecord::getValue).sorted().collect(Collectors.toList()));
        all.addAll(this.other.stream().map(PlayableObjectRecord::getValue).sorted().collect(Collectors.toList()));
        return all;
    }

    public List<UUID> getPlayableAbilityIds() {
        ArrayList<UUID> all = new ArrayList<UUID>();
        all.addAll(this.basicManaAbilities.stream().map(PlayableObjectRecord::getId).collect(Collectors.toList()));
        all.addAll(this.basicPlayAbilities.stream().map(PlayableObjectRecord::getId).collect(Collectors.toList()));
        all.addAll(this.basicCastAbilities.stream().map(PlayableObjectRecord::getId).collect(Collectors.toList()));
        all.addAll(this.other.stream().map(PlayableObjectRecord::getId).collect(Collectors.toList()));
        return all;
    }

    public int getPlayableImportantAmount() {
        return this.other.size();
    }
}

