/*
 * Decompiled with CFR 0.152.
 */
package mage.players;

import java.io.Serializable;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.ApprovingObject;
import mage.MageIdentifier;
import mage.MageItem;
import mage.MageObject;
import mage.Mana;
import mage.abilities.Abilities;
import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.Mode;
import mage.abilities.Modes;
import mage.abilities.SpellAbility;
import mage.abilities.TriggeredAbility;
import mage.abilities.costs.AlternativeSourceCosts;
import mage.abilities.costs.Cost;
import mage.abilities.costs.Costs;
import mage.abilities.costs.mana.ManaCost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.mana.ManaOptions;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.decks.Deck;
import mage.choices.Choice;
import mage.constants.AbilityType;
import mage.constants.ManaType;
import mage.constants.MultiAmountType;
import mage.constants.Outcome;
import mage.constants.PlanarDieRollResult;
import mage.constants.PlayerAction;
import mage.constants.RangeOfInfluence;
import mage.constants.Zone;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.counters.Counters;
import mage.designations.Designation;
import mage.designations.DesignationType;
import mage.filter.FilterCard;
import mage.filter.FilterMana;
import mage.game.Game;
import mage.game.GameState;
import mage.game.Graveyard;
import mage.game.Table;
import mage.game.draft.Draft;
import mage.game.events.GameEvent;
import mage.game.match.Match;
import mage.game.match.MatchPlayer;
import mage.game.permanent.Permanent;
import mage.game.tournament.Tournament;
import mage.players.Library;
import mage.players.ManaPool;
import mage.players.PlayableObjectsList;
import mage.players.net.UserData;
import mage.target.Target;
import mage.target.TargetAmount;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;
import mage.util.Copyable;
import mage.util.MultiAmountMessage;

public interface Player
extends MageItem,
Copyable<Player> {
    public boolean isHuman();

    public boolean isTestMode();

    public void setTestMode(boolean var1);

    public boolean isFastFailInTestMode();

    public void setFastFailInTestMode(boolean var1);

    default public boolean isComputer() {
        return !this.isHuman();
    }

    public String getName();

    public String getLogName();

    public RangeOfInfluence getRange();

    public Library getLibrary();

    public Cards getSideboard();

    public Graveyard getGraveyard();

    public Abilities<Ability> getAbilities();

    public void addAbility(Ability var1);

    public Counters getCountersAsCopy();

    public int getLife();

    public void initLife(int var1);

    public void setLife(int var1, Game var2, Ability var3);

    public int loseLife(int var1, Game var2, Ability var3, boolean var4, UUID var5);

    public int loseLife(int var1, Game var2, Ability var3, boolean var4);

    public int gainLife(int var1, Game var2, Ability var3);

    public void exchangeLife(Player var1, Ability var2, Game var3);

    public int damage(int var1, Ability var2, Game var3);

    public int damage(int var1, UUID var2, Ability var3, Game var4);

    public int damage(int var1, UUID var2, Ability var3, Game var4, boolean var5, boolean var6);

    public int damage(int var1, UUID var2, Ability var3, Game var4, boolean var5, boolean var6, List<UUID> var7);

    public boolean isCanLoseLife();

    public void setCanLoseLife(boolean var1);

    public void setCanGainLife(boolean var1);

    public boolean isCanGainLife();

    public void addPayLifeCostRestriction(PayLifeCostRestriction var1);

    public EnumSet<PayLifeCostRestriction> getPayLifeCostRestrictions();

    public boolean canPayLifeCost(Ability var1);

    public boolean canPaySacrificeCost(Permanent var1, Ability var2, UUID var3, Game var4);

    public void setLifeTotalCanChange(boolean var1);

    public boolean isLifeTotalCanChange();

    public void setLoseByZeroOrLessLife(boolean var1);

    public boolean canLoseByZeroOrLessLife();

    public void setPlotFromTopOfLibrary(boolean var1);

    public boolean canPlotFromTopOfLibrary();

    public void setDrawsFromBottom(boolean var1);

    public boolean isDrawsFromBottom();

    public void setDrawsOnOpponentsTurn(boolean var1);

    public boolean isDrawsOnOpponentsTurn();

    public int getSpeed();

    public void initSpeed(Game var1);

    public void increaseSpeed(Game var1);

    public void decreaseSpeed(Game var1);

    public List<AlternativeSourceCosts> getAlternativeSourceCosts();

    public Cards getHand();

    public void incrementLandsPlayed();

    public void resetLandsPlayed();

    public int getLandsPlayed();

    public int getLandsPerTurn();

    public void setLandsPerTurn(int var1);

    public int getMaxHandSize();

    public void setMaxHandSize(int var1);

    public int getMaxAttackedBy();

    public void setMaxAttackedBy(int var1);

    public boolean isPassed();

    public void pass(Game var1);

    public void resetPassed();

    public void resetPlayerPassedActions();

    public boolean getPassedTurn();

    public boolean getPassedUntilEndOfTurn();

    public boolean getPassedUntilNextMain();

    public boolean getPassedUntilStackResolved();

    public boolean getPassedUntilEndStepBeforeMyTurn();

    public boolean getPassedAllTurns();

    public AbilityType getJustActivatedType();

    public void setJustActivatedType(AbilityType var1);

    public boolean hasLost();

    public boolean hasDrew();

    public boolean hasWon();

    public boolean hasQuit();

    public void quit(Game var1);

    public boolean hasTimerTimeout();

    public void timerTimeout(Game var1);

    public boolean hasIdleTimeout();

    public void idleTimeout(Game var1);

    public boolean hasLeft();

    public boolean isInGame();

    public boolean canRespond();

    public ManaPool getManaPool();

    public boolean hasPlayerInRange(UUID var1);

    public boolean isTopCardRevealed();

    public void setTopCardRevealed(boolean var1);

    public UserData getUserData();

    public void setUserData(UserData var1);

    public boolean canLose(Game var1);

    public boolean autoLoseGame();

    public Set<UUID> getPlayersUnderYourControl();

    public boolean controlPlayersTurn(Game var1, UUID var2, String var3);

    public void setTurnControlledBy(UUID var1);

    public List<UUID> getTurnControllers();

    public UUID getTurnControlledBy();

    public void resetOtherTurnsControlled();

    public boolean isGameUnderControl();

    public void setGameUnderYourControl(Game var1, boolean var2);

    public void setGameUnderYourControl(Game var1, boolean var2, boolean var3);

    public void setAllowBadMoves(boolean var1);

    public void init(Game var1);

    public void useDeck(Deck var1, Game var2);

    public void reset();

    public void shuffleLibrary(Ability var1, Game var2);

    public int drawCards(int var1, Ability var2, Game var3);

    public int drawCards(int var1, Ability var2, Game var3, GameEvent var4);

    public boolean cast(SpellAbility var1, Game var2, boolean var3, ApprovingObject var4);

    public SpellAbility chooseAbilityForCast(Card var1, Game var2, boolean var3);

    public ActivatedAbility chooseLandOrSpellAbility(Card var1, Game var2, boolean var3);

    public boolean removeFromHand(Card var1, Game var2);

    public boolean removeFromBattlefield(Permanent var1, Ability var2, Game var3);

    public boolean putInGraveyard(Card var1, Game var2);

    public boolean removeFromGraveyard(Card var1, Game var2);

    public boolean removeFromLibrary(Card var1, Game var2);

    public boolean searchLibrary(TargetCardInLibrary var1, Ability var2, Game var3);

    public boolean searchLibrary(TargetCardInLibrary var1, Ability var2, Game var3, UUID var4);

    public boolean seekCard(FilterCard var1, Ability var2, Game var3);

    public void lookAtAllLibraries(Ability var1, Game var2);

    public boolean canPlayLand();

    public boolean playCard(Card var1, Game var2, boolean var3, ApprovingObject var4);

    public boolean playLand(Card var1, Game var2, boolean var3);

    public boolean activateAbility(ActivatedAbility var1, Game var2);

    public boolean triggerAbility(TriggeredAbility var1, Game var2);

    public boolean canBeTargetedBy(MageObject var1, UUID var2, Ability var3, Game var4);

    public boolean hasProtectionFrom(MageObject var1, Game var2);

    public List<Boolean> flipCoins(Ability var1, Game var2, int var3, boolean var4);

    public boolean flipCoin(Ability var1, Game var2, boolean var3);

    public boolean flipCoinResult(Game var1);

    default public int rollDice(Outcome outcome, Ability source, Game game, int numSides) {
        return this.rollDice(outcome, source, game, numSides, 1, 0).stream().findFirst().orElse(0);
    }

    public List<Integer> rollDice(Outcome var1, Ability var2, Game var3, int var4, int var5, int var6);

    public int rollDieResult(int var1, Game var2);

    default public PlanarDieRollResult rollPlanarDie(Outcome outcome, Ability source, Game game) {
        return this.rollPlanarDie(outcome, source, game, 2, 2);
    }

    public PlanarDieRollResult rollPlanarDie(Outcome var1, Ability var2, Game var3, int var4, int var5);

    public Card discardOne(boolean var1, boolean var2, Ability var3, Game var4);

    public Cards discard(int var1, boolean var2, boolean var3, Ability var4, Game var5);

    public Cards discard(int var1, int var2, boolean var3, Ability var4, Game var5);

    public Cards discard(Cards var1, boolean var2, Ability var3, Game var4);

    public void discardToMax(Game var1);

    public boolean discard(Card var1, boolean var2, Ability var3, Game var4);

    public void lost(Game var1);

    public void lostForced(Game var1);

    public void drew(Game var1);

    public void won(Game var1);

    public void leave();

    public void concede(Game var1);

    public void abort();

    public void abortReset();

    public void signalPlayerConcede(boolean var1);

    public void signalPlayerCheat();

    public void skip();

    public void sendPlayerAction(PlayerAction var1, Game var2, Object var3);

    public int getStoredBookmark();

    public void setStoredBookmark(int var1);

    public void resetStoredBookmark(Game var1);

    default public GameState restoreState(int bookmark, String text, Game game) {
        GameState state = game.restoreState(bookmark, text);
        if (this.getStoredBookmark() >= bookmark) {
            this.resetStoredBookmark(game);
        }
        return state;
    }

    public void revealCards(Ability var1, Cards var2, Game var3);

    public void revealCards(String var1, Cards var2, Game var3);

    public void revealCards(Ability var1, String var2, Cards var3, Game var4);

    public void revealCards(String var1, Cards var2, Game var3, boolean var4);

    public void revealCards(Ability var1, String var2, Cards var3, Game var4, boolean var5);

    public void lookAtCards(String var1, Card var2, Game var3);

    public void lookAtCards(String var1, Cards var2, Game var3);

    public void lookAtCards(Ability var1, String var2, Cards var3, Game var4);

    @Override
    public Player copy();

    public void restore(Player var1);

    public void setResponseString(String var1);

    public void setResponseUUID(UUID var1);

    public void setResponseBoolean(Boolean var1);

    public void setResponseInteger(Integer var1);

    public void setResponseManaType(UUID var1, ManaType var2);

    public boolean priority(Game var1);

    public boolean choose(Outcome var1, Target var2, Ability var3, Game var4);

    public boolean choose(Outcome var1, Target var2, Ability var3, Game var4, Map<String, Serializable> var5);

    public boolean choose(Outcome var1, Cards var2, TargetCard var3, Ability var4, Game var5);

    public boolean chooseTarget(Outcome var1, Target var2, Ability var3, Game var4);

    public boolean chooseTarget(Outcome var1, Cards var2, TargetCard var3, Ability var4, Game var5);

    public boolean chooseTargetAmount(Outcome var1, TargetAmount var2, Ability var3, Game var4);

    public boolean chooseMulligan(Game var1);

    public boolean chooseUse(Outcome var1, String var2, Ability var3, Game var4);

    public boolean chooseUse(Outcome var1, String var2, String var3, String var4, String var5, Ability var6, Game var7);

    public boolean choose(Outcome var1, Choice var2, Game var3);

    public boolean choosePile(Outcome var1, String var2, List<? extends Card> var3, List<? extends Card> var4, Game var5);

    public boolean playMana(Ability var1, ManaCost var2, String var3, Game var4);

    public boolean putCardsOnBottomOfLibrary(Cards var1, Game var2, Ability var3, boolean var4);

    public boolean putCardsOnBottomOfLibrary(Card var1, Game var2, Ability var3);

    public boolean putCardOnTopXOfLibrary(Card var1, Game var2, Ability var3, int var4, boolean var5);

    public boolean putCardsOnTopOfLibrary(Cards var1, Game var2, Ability var3, boolean var4);

    public boolean putCardsOnTopOfLibrary(Card var1, Game var2, Ability var3, boolean var4);

    public boolean shuffleCardsToLibrary(Cards var1, Game var2, Ability var3);

    public boolean shuffleCardsToLibrary(Card var1, Game var2, Ability var3);

    public int announceX(int var1, int var2, String var3, Game var4, Ability var5, boolean var6);

    public int chooseReplacementEffect(Map<String, String> var1, Map<String, MageObject> var2, Game var3);

    public TriggeredAbility chooseTriggeredAbility(List<TriggeredAbility> var1, Game var2);

    public Mode chooseMode(Modes var1, Ability var2, Game var3);

    public void selectAttackers(Game var1, UUID var2);

    public void selectBlockers(Ability var1, Game var2, UUID var3);

    public int getAmount(int var1, int var2, String var3, Ability var4, Game var5);

    default public List<Integer> getMultiAmount(Outcome outcome, List<String> messages, int optionMin, int totalMin, int totalMax, MultiAmountType type, Game game) {
        if (optionMin > totalMax || optionMin * messages.size() > totalMin) {
            throw new IllegalArgumentException(String.format("Wrong code usage: getMultiAmount found bad option min/max values: %d/%d", optionMin, totalMax));
        }
        List<MultiAmountMessage> constraints = messages.stream().map(s -> new MultiAmountMessage((String)s, optionMin, totalMax)).collect(Collectors.toList());
        return this.getMultiAmountWithIndividualConstraints(outcome, constraints, totalMin, totalMax, type, game);
    }

    public List<Integer> getMultiAmountWithIndividualConstraints(Outcome var1, List<MultiAmountMessage> var2, int var3, int var4, MultiAmountType var5, Game var6);

    public void sideboard(Match var1, Deck var2);

    public void construct(Tournament var1, Deck var2);

    public void pickCard(List<Card> var1, Deck var2, Draft var3);

    public void declareAttacker(UUID var1, UUID var2, Game var3, boolean var4);

    public void declareBlocker(UUID var1, UUID var2, UUID var3, Game var4);

    public void declareBlocker(UUID var1, UUID var2, UUID var3, Game var4, boolean var5);

    public List<Permanent> getAvailableAttackers(Game var1);

    public List<Permanent> getAvailableAttackers(UUID var1, Game var2);

    public List<Permanent> getAvailableBlockers(Game var1);

    public void beginTurn(Game var1);

    public void endOfTurn(Game var1);

    public void phasing(Game var1);

    public void untap(Game var1);

    public void updateRange(Game var1);

    public ManaOptions getManaAvailable(Game var1);

    public void addAvailableTriggeredMana(List<Mana> var1);

    public List<List<Mana>> getAvailableTriggeredMana();

    public List<ActivatedAbility> getPlayable(Game var1, boolean var2);

    public List<Ability> getPlayableOptions(Ability var1, Game var2);

    public PlayableObjectsList getPlayableObjects(Game var1, Zone var2);

    public Map<UUID, ActivatedAbility> getPlayableActivatedAbilities(MageObject var1, Zone var2, Game var3);

    public boolean addCounters(Counter var1, UUID var2, Ability var3, Game var4);

    public void loseCounters(String var1, int var2, Ability var3, Game var4);

    public int loseAllCounters(Ability var1, Game var2);

    public int loseAllCounters(String var1, Ability var2, Game var3);

    public int getCountersCount(CounterType var1);

    public int getCountersCount(String var1);

    public int getCountersTotalCount();

    public List<UUID> getAttachments();

    public boolean addAttachment(UUID var1, Ability var2, Game var3);

    public boolean removeAttachment(Permanent var1, Ability var2, Game var3);

    public void becomesActivePlayer();

    public int getTurns();

    public boolean lookAtFaceDownCard(Card var1, Game var2, int var3);

    public void setPriorityTimeLeft(int var1);

    public int getPriorityTimeLeft();

    public void setBufferTimeLeft(int var1);

    public int getBufferTimeLeft();

    public void setReachedNextTurnAfterLeaving(boolean var1);

    public boolean hasReachedNextTurnAfterLeaving();

    public boolean canJoinTable(Table var1);

    public void addCommanderId(UUID var1);

    @Deprecated
    public Set<UUID> getCommandersIds();

    public boolean moveCards(Cards var1, Zone var2, Ability var3, Game var4);

    public boolean moveCards(Card var1, Zone var2, Ability var3, Game var4);

    public boolean moveCards(Card var1, Zone var2, Ability var3, Game var4, boolean var5, boolean var6, boolean var7, List<UUID> var8);

    public boolean moveCards(Set<? extends Card> var1, Zone var2, Ability var3, Game var4);

    public boolean moveCards(Set<? extends Card> var1, Zone var2, Ability var3, Game var4, boolean var5, boolean var6, boolean var7, List<UUID> var8);

    public boolean moveCardsToExile(Card var1, Ability var2, Game var3, boolean var4, UUID var5, String var6);

    public boolean moveCardsToExile(Set<Card> var1, Ability var2, Game var3, boolean var4, UUID var5, String var6);

    public boolean moveCardToHandWithInfo(Card var1, Ability var2, Game var3, boolean var4);

    public boolean moveCardsToHandWithInfo(Cards var1, Ability var2, Game var3, boolean var4);

    @Deprecated
    public boolean moveCardToExileWithInfo(Card var1, UUID var2, String var3, Ability var4, Game var5, Zone var6, boolean var7);

    public boolean moveCardToGraveyardWithInfo(Card var1, Ability var2, Game var3, Zone var4);

    public Set<Card> moveCardsToGraveyardWithInfo(Set<? extends Card> var1, Ability var2, Game var3, Zone var4);

    public boolean moveCardToLibraryWithInfo(Card var1, Ability var2, Game var3, Zone var4, boolean var5, boolean var6);

    public boolean moveCardToCommandWithInfo(Card var1, Ability var2, Game var3, Zone var4);

    public Cards millCards(int var1, Ability var2, Game var3);

    public boolean hasOpponent(UUID var1, Game var2);

    public void cleanUpOnMatchEnd();

    default public void setCastSourceIdWithAlternateMana(UUID sourceId, ManaCosts<ManaCost> manaCosts, Costs<Cost> costs) {
        this.setCastSourceIdWithAlternateMana(sourceId, manaCosts, costs, MageIdentifier.Default);
    }

    public void setCastSourceIdWithAlternateMana(UUID var1, ManaCosts<ManaCost> var2, Costs<Cost> var3, MageIdentifier var4);

    public Map<UUID, Set<MageIdentifier>> getCastSourceIdWithAlternateMana();

    public Map<UUID, Map<MageIdentifier, ManaCosts<ManaCost>>> getCastSourceIdManaCosts();

    public Map<UUID, Map<MageIdentifier, Costs<Cost>>> getCastSourceIdCosts();

    public void clearCastSourceIdManaCosts();

    public void addPermissionToShowHandCards(UUID var1);

    public boolean hasUserPermissionToSeeHand(UUID var1);

    public void revokePermissionToSeeHandCards();

    public boolean isPlayerAllowedToRequestHand(UUID var1, UUID var2);

    public void addPlayerToRequestedHandList(UUID var1, UUID var2);

    public Set<UUID> getUsersAllowedToSeeHandCards();

    public void setPayManaMode(boolean var1);

    public boolean isInPayManaMode();

    public void setMatchPlayer(MatchPlayer var1);

    public MatchPlayer getMatchPlayer();

    public boolean scry(int var1, Ability var2, Game var3);

    public SurveilResult doSurveil(int var1, Ability var2, Game var3);

    default public boolean surveil(int value, Ability source, Game game) {
        SurveilResult result = this.doSurveil(value, source, game);
        return result.hasSurveilled();
    }

    public boolean addTargets(Ability var1, Game var2);

    public boolean hasDesignation(DesignationType var1);

    public void addDesignation(Designation var1);

    public List<Designation> getDesignations();

    public void addPhyrexianToColors(FilterMana var1);

    public FilterMana getPhyrexianColors();

    public Permanent getRingBearer(Game var1);

    public void chooseRingBearer(Game var1);

    default public boolean getStrictChooseMode() {
        return false;
    }

    public UserData getControllingPlayersUserData(Game var1);

    public Player getRealPlayer();

    default public Player prepareControllableProxy(Player playerUnderControl) {
        return this;
    }

    public static class SurveilResult {
        private final boolean surveilled;
        private final int numberInGraveyard;
        private final int numberOnTop;

        private SurveilResult(boolean surveilled, int inGrave, int onTop) {
            this.surveilled = surveilled;
            this.numberInGraveyard = inGrave;
            this.numberOnTop = onTop;
        }

        public static SurveilResult noSurveil() {
            return new SurveilResult(false, 0, 0);
        }

        public static SurveilResult surveil(int inGrave, int onTop) {
            return new SurveilResult(true, inGrave, onTop);
        }

        public boolean hasSurveilled() {
            return this.surveilled;
        }

        public int getNumberPutInGraveyard() {
            return this.numberInGraveyard;
        }

        public int getNumberPutOnTop() {
            return this.numberOnTop;
        }
    }

    public static enum PayLifeCostRestriction {
        CAST_SPELLS,
        ACTIVATE_NON_MANA_ABILITIES,
        ACTIVATE_MANA_ABILITIES;

    }
}

