/*
 * Decompiled with CFR 0.152.
 */
package mage.target;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetObject;

public class TargetPermanent
extends TargetObject {
    protected FilterPermanent filter;

    public TargetPermanent() {
        this(StaticFilters.FILTER_PERMANENT);
    }

    public TargetPermanent(FilterPermanent filter) {
        this(1, filter);
    }

    public TargetPermanent(int numTargets, FilterPermanent filter) {
        this(numTargets, numTargets, filter);
    }

    public TargetPermanent(int minNumTargets, int maxNumTargets, FilterPermanent filter) {
        this(minNumTargets, maxNumTargets, filter, false);
    }

    public TargetPermanent(int minNumTargets, int maxNumTargets, FilterPermanent filter, boolean notTarget) {
        this.minNumberOfTargets = minNumTargets;
        this.maxNumberOfTargets = maxNumTargets;
        this.zone = Zone.BATTLEFIELD;
        this.filter = filter;
        this.targetName = filter.getMessage();
        this.notTarget = notTarget;
    }

    protected TargetPermanent(TargetPermanent target) {
        super(target);
        this.filter = target.filter.copy();
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        return this.canTarget(source == null ? null : source.getControllerId(), id, source, game);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        Permanent permanent = game.getPermanent(id);
        if (permanent == null) {
            return false;
        }
        if (!(source == null || this.isNotTarget() || permanent.canBeTargetedBy(game.getObject(source.getId()), playerId, source, game) && permanent.canBeTargetedBy(game.getObject(source), playerId, source, game))) {
            return false;
        }
        return this.filter.match(permanent, playerId, source, game);
    }

    @Override
    public FilterPermanent getFilter() {
        return this.filter;
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, sourceControllerId, source, game)) {
            possibleTargets.add(permanent.getId());
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public TargetPermanent copy() {
        return new TargetPermanent(this);
    }

    public void replaceFilter(FilterPermanent filter) {
        this.filter = filter;
        this.targetName = filter.getMessage();
    }
}

