/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.constants.Zone;
import mage.filter.Filter;
import mage.filter.FilterAbility;
import mage.filter.FilterStackObject;
import mage.game.Game;
import mage.game.stack.StackAbility;
import mage.game.stack.StackObject;
import mage.target.TargetObject;

public class TargetActivatedAbility
extends TargetObject {
    protected final FilterStackObject filter;

    public TargetActivatedAbility() {
        this(new FilterStackObject("activated ability"));
    }

    public TargetActivatedAbility(FilterStackObject filter) {
        this.minNumberOfTargets = 1;
        this.maxNumberOfTargets = 1;
        this.zone = Zone.STACK;
        this.targetName = filter.getMessage();
        this.filter = filter;
    }

    protected TargetActivatedAbility(TargetActivatedAbility target) {
        super(target);
        this.filter = target.filter.copy();
    }

    @Override
    public boolean canTarget(UUID id, Ability source, Game game) {
        if (source != null && source.getSourceId().equals(id)) {
            return false;
        }
        StackObject stackObject = game.getStack().getStackObject(id);
        return stackObject != null && stackObject.getStackAbility() != null && stackObject.getStackAbility().isActivatedAbility() && source != null && this.filter.match(stackObject, source.getControllerId(), source, game);
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        for (StackObject stackObject : game.getStack()) {
            if (!stackObject.getStackAbility().isActivatedAbility() || !game.getState().getPlayersInRange(sourceControllerId, game).contains(stackObject.getStackAbility().getControllerId()) || !this.filter.match(stackObject, sourceControllerId, source, game) || !this.notContains(stackObject.getId())) continue;
            possibleTargets.add(stackObject.getStackAbility().getId());
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public TargetActivatedAbility copy() {
        return new TargetActivatedAbility(this);
    }

    @Override
    public Filter<Ability> getFilter() {
        return new FilterAbility();
    }

    @Override
    public String getTargetedName(Game game) {
        StringBuilder sb = new StringBuilder("activated ability (");
        for (UUID targetId : this.getTargets()) {
            StackAbility object = (StackAbility)game.getObject(targetId);
            if (object == null) continue;
            sb.append(object.getRule()).append(' ');
        }
        return sb.toString().trim() + ")";
    }
}

