/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.ExileZone;
import mage.game.Game;
import mage.target.TargetCard;

public class TargetCardInExile
extends TargetCard {
    private final UUID zoneId;

    public TargetCardInExile(FilterCard filter) {
        this(1, 1, filter);
    }

    public TargetCardInExile(int minNumTargets, int maxNumTargets, FilterCard filter) {
        this(minNumTargets, maxNumTargets, filter, null);
    }

    public TargetCardInExile(FilterCard filter, UUID zoneId) {
        this(1, 1, filter, zoneId);
    }

    public TargetCardInExile(int minNumTargets, int maxNumTargets, FilterCard filter, UUID zoneId) {
        super(minNumTargets, maxNumTargets, Zone.EXILED, filter);
        this.zoneId = zoneId;
    }

    protected TargetCardInExile(TargetCardInExile target) {
        super(target);
        this.zoneId = target.zoneId;
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets;
        block3: {
            block2: {
                possibleTargets = new HashSet<UUID>();
                if (this.zoneId != null) break block2;
                for (Card card : game.getExile().getCardsInRange(game, sourceControllerId)) {
                    if (!this.filter.match(card, sourceControllerId, source, game)) continue;
                    possibleTargets.add(card.getId());
                }
                break block3;
            }
            ExileZone exileZone = game.getExile().getExileZone(this.zoneId);
            if (exileZone == null) break block3;
            for (Card card : exileZone.getCards(game)) {
                if (!this.filter.match(card, sourceControllerId, source, game)) continue;
                possibleTargets.add(card.getId());
            }
        }
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public TargetCardInExile copy() {
        return new TargetCardInExile(this);
    }
}

