/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.TargetPermanent;
import mage.target.common.TargetOpponent;

public class TargetOpponentsChoicePermanent
extends TargetPermanent {
    protected UUID opponentId = null;

    public TargetOpponentsChoicePermanent(int minNumTargets, int maxNumTargets, FilterPermanent filter, boolean notTarget) {
        super(minNumTargets, maxNumTargets, filter, notTarget);
    }

    protected TargetOpponentsChoicePermanent(TargetOpponentsChoicePermanent target) {
        super(target);
        this.opponentId = target.opponentId;
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        Permanent permanent = game.getPermanent(id);
        if (this.opponentId != null && permanent != null && source != null) {
            boolean canSourceControllerTarget = true;
            if (!(this.isNotTarget() || permanent.canBeTargetedBy(game.getObject(source.getId()), playerId, source, game) && permanent.canBeTargetedBy(game.getObject(source), playerId, source, game))) {
                canSourceControllerTarget = false;
            }
            canSourceControllerTarget &= super.canTarget(this.opponentId, id, source, game);
            return canSourceControllerTarget &= this.filter.match(permanent, this.opponentId, source, game);
        }
        return false;
    }

    @Override
    public boolean chooseTarget(Outcome outcome, UUID playerId, Ability source, Game game) {
        if (this.opponentId == null) {
            TargetOpponent target = new TargetOpponent(true);
            Player player = game.getPlayer(playerId);
            if (player != null && player.chooseTarget(Outcome.Detriment, target, source, game)) {
                this.opponentId = target.getFirstTarget();
            }
        }
        if (this.opponentId == null) {
            return false;
        }
        return super.chooseTarget(outcome, this.opponentId, source, game);
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        MageObject sourceObject = game.getObject(source);
        Player player = game.getPlayer(sourceControllerId);
        if (sourceObject == null || player == null) {
            return false;
        }
        for (UUID oppId : game.getState().getPlayersInRange(player.getId(), game)) {
            int counter = 0;
            Player opp = game.getPlayer(oppId);
            if (opp == null || !player.hasOpponent(opp.getId(), game)) continue;
            for (Permanent perm : game.getBattlefield().getActivePermanents(opp.getId(), game)) {
                if (this.targets.containsKey(perm.getId()) || !this.filter.match(perm, opp.getId(), source, game) || !perm.canBeTargetedBy(sourceObject, sourceControllerId, source, game) || ++counter < this.minNumberOfTargets) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public TargetOpponentsChoicePermanent copy() {
        return new TargetOpponentsChoicePermanent(this);
    }

    @Override
    public boolean isRequired() {
        return true;
    }

    @Override
    public boolean isRequired(UUID sourceId, Game game) {
        return true;
    }

    @Override
    public boolean isRequired(Ability ability) {
        return true;
    }
}

