/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.StaticValue;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetAmount;

public class TargetPermanentAmount
extends TargetAmount {
    protected final FilterPermanent filter;

    public TargetPermanentAmount(int amount, int minNumberOfTargets, FilterPermanent filter) {
        this(amount, minNumberOfTargets, amount, filter);
    }

    public TargetPermanentAmount(DynamicValue amount, int minNumberOfTargets, FilterPermanent filter) {
        this(amount, minNumberOfTargets, Integer.MAX_VALUE, filter);
    }

    public TargetPermanentAmount(int amount, int minNumberOfTargets, int maxNumberOfTargets, FilterPermanent filter) {
        this(StaticValue.get(amount), minNumberOfTargets, maxNumberOfTargets, filter);
    }

    public TargetPermanentAmount(DynamicValue amount, int minNumberOfTargets, int maxNumberOfTargets, FilterPermanent filter) {
        super(amount, minNumberOfTargets, maxNumberOfTargets);
        this.zone = Zone.ALL;
        this.filter = filter;
        this.targetName = filter.getMessage();
    }

    protected TargetPermanentAmount(TargetPermanentAmount target) {
        super(target);
        this.filter = target.filter.copy();
    }

    @Override
    public TargetPermanentAmount copy() {
        return new TargetPermanentAmount(this);
    }

    @Override
    public FilterPermanent getFilter() {
        return this.filter;
    }

    @Override
    public boolean canTarget(UUID objectId, Ability source, Game game) {
        Permanent permanent = game.getPermanent(objectId);
        if (permanent == null) {
            return false;
        }
        if (source == null) {
            return this.filter.match(permanent, game);
        }
        return (this.isNotTarget() || permanent.canBeTargetedBy(game.getObject(source), source.getControllerId(), source, game)) && this.filter.match(permanent, source.getControllerId(), source, game);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID objectId, Ability source, Game game) {
        return this.canTarget(objectId, source, game);
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set<UUID> possibleTargets = game.getBattlefield().getActivePermanents(this.filter, sourceControllerId, source, game).stream().map(MageItem::getId).collect(Collectors.toSet());
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public String getTargetedName(Game game) {
        StringBuilder sb = new StringBuilder();
        this.getTargets().forEach(targetId -> {
            Permanent permanent = game.getPermanent((UUID)targetId);
            if (permanent != null) {
                sb.append(permanent.getLogName()).append(" (").append(this.getTargetAmount((UUID)targetId)).append(") ");
            }
        });
        return sb.toString().trim();
    }
}

