/*
 * Decompiled with CFR 0.152.
 */
package mage.target.common;

import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageItem;
import mage.abilities.Ability;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

public class TargetTappedPermanentAsYouCast
extends TargetPermanent {
    public TargetTappedPermanentAsYouCast() {
    }

    public TargetTappedPermanentAsYouCast(FilterPermanent filter) {
        this.filter = filter;
        this.targetName = filter.getMessage();
    }

    private TargetTappedPermanentAsYouCast(TargetTappedPermanentAsYouCast target) {
        super(target);
    }

    @Override
    public TargetTappedPermanentAsYouCast copy() {
        return new TargetTappedPermanentAsYouCast(this);
    }

    @Override
    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        Set<UUID> possibleTargets = game.getBattlefield().getActivePermanents(this.getFilter(), sourceControllerId, source, game).stream().filter(Permanent::isTapped).map(MageItem::getId).collect(Collectors.toSet());
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    @Override
    public boolean canChoose(UUID sourceControllerId, Ability source, Game game) {
        return this.canChooseFromPossibleTargets(sourceControllerId, source, game);
    }

    @Override
    public boolean canTarget(UUID playerId, UUID id, Ability source, Game game) {
        if (super.canTarget(playerId, id, source, game)) {
            Permanent permanent = game.getPermanent(id);
            return permanent != null && permanent.isTapped();
        }
        return false;
    }

    @Override
    public boolean stillLegalTarget(UUID controllerId, UUID id, Ability source, Game game) {
        Permanent permanent = game.getPermanent(id);
        return permanent != null && this.getFilter().match(permanent, game) && super.canTarget(controllerId, id, source, game);
    }
}

