/*
 * Decompiled with CFR 0.152.
 */
package mage.target.targetpointer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.Targets;
import mage.target.targetpointer.TargetPointerImpl;

public abstract class NthTargetPointer
extends TargetPointerImpl {
    private static final List<UUID> emptyTargets = Collections.unmodifiableList(new ArrayList());
    private final Map<UUID, Integer> zoneChangeCounter = new HashMap<UUID, Integer>();
    private final int targetIndex;

    protected NthTargetPointer(int targetNumber) {
        this.targetIndex = targetNumber - 1;
    }

    protected NthTargetPointer(NthTargetPointer nthTargetPointer) {
        super(nthTargetPointer);
        this.targetIndex = nthTargetPointer.targetIndex;
        this.zoneChangeCounter.putAll(nthTargetPointer.zoneChangeCounter);
    }

    @Override
    public void init(Game game, Ability source) {
        if (this.isInitialized()) {
            return;
        }
        this.setInitialized();
        if (source.getTargets().size() <= this.targetIndex) {
            this.wrongTargetsUsage(source);
            return;
        }
        for (UUID target : ((Target)source.getTargets().get(this.targetIndex)).getTargets()) {
            Card card = game.getCard(target);
            if (card == null) continue;
            this.zoneChangeCounter.put(target, card.getZoneChangeCounter(game));
        }
    }

    private void wrongTargetsUsage(Ability source) {
        if (this.targetIndex > 0 && source.getTargetAdjuster() == null) {
            throw new IllegalStateException("Wrong code usage: source ability miss targets setup for target pointer - " + this.getClass().getSimpleName() + " - " + source.getClass().getSimpleName() + " - " + source);
        }
    }

    @Override
    public List<UUID> getTargets(Game game, Ability source) {
        if (source.getTargets().size() <= this.targetIndex) {
            this.wrongTargetsUsage(source);
            return emptyTargets;
        }
        ArrayList<UUID> res = new ArrayList<UUID>();
        for (UUID targetId : ((Target)source.getTargets().get(this.targetIndex)).getTargets()) {
            if (this.isOutdatedTarget(game, targetId)) continue;
            res.add(targetId);
        }
        return res;
    }

    private boolean isOutdatedTarget(Game game, UUID targetId) {
        int needZcc = this.zoneChangeCounter.getOrDefault(targetId, 0);
        if (needZcc == 0) {
            return false;
        }
        Card card = game.getCard(targetId);
        if (card != null && card.getZoneChangeCounter(game) == needZcc) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(targetId);
        return permanent == null || permanent.getZoneChangeCounter(game) != needZcc;
    }

    @Override
    public UUID getFirst(Game game, Ability source) {
        if (source.getTargets().size() <= this.targetIndex) {
            this.wrongTargetsUsage(source);
            return null;
        }
        UUID targetId = ((Target)source.getTargets().get(this.targetIndex)).getFirstTarget();
        if (this.isOutdatedTarget(game, targetId)) {
            return null;
        }
        return targetId;
    }

    @Override
    public Permanent getFirstTargetPermanentOrLKI(Game game, Ability source) {
        if (source.getTargets().size() < this.targetIndex) {
            this.wrongTargetsUsage(source);
            return null;
        }
        UUID targetId = ((Target)source.getTargets().get(this.targetIndex)).getFirstTarget();
        if (this.zoneChangeCounter.containsKey(targetId)) {
            MageObjectReference needRef = new MageObjectReference(targetId, this.zoneChangeCounter.getOrDefault(targetId, 0), game);
            return game.getPermanentOrLKIBattlefield(needRef);
        }
        Permanent permanent = game.getPermanent(targetId);
        if (permanent == null) {
            permanent = (Permanent)game.getLastKnownInformation(targetId, Zone.BATTLEFIELD);
        }
        return permanent;
    }

    @Override
    public String describeTargets(Targets targets, String defaultDescription) {
        if (this.targetDescription != null) {
            return this.targetDescription;
        }
        if (targets.size() <= this.targetIndex) {
            return defaultDescription;
        }
        return ((Target)targets.get(this.targetIndex)).getDescription();
    }

    @Override
    public boolean isPlural(Targets targets) {
        return targets.size() > this.targetIndex && ((Target)targets.get(this.targetIndex)).getMaxNumberOfTargets() > 1;
    }
}

