/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mage.cards.decks.DeckValidator;
import mage.util.StreamUtils;
import org.apache.log4j.Logger;

public final class DeckUtil {
    private static final Logger logger = Logger.getLogger(DeckUtil.class);

    public static long getDeckHash(List<String> mainCards, List<String> sideboardCards, boolean ignoreMainBasicLands) {
        ArrayList<String> all = new ArrayList<String>(mainCards);
        all.addAll(sideboardCards);
        if (ignoreMainBasicLands) {
            all.removeIf(DeckValidator.MAIN_BASIC_LAND_NAMES::contains);
        }
        Collections.sort(all);
        return DeckUtil.getStringHash(((Object)all).toString());
    }

    private static long getStringHash(String string) {
        long h = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)string.charAt(i);
        }
        return h;
    }

    public static String writeTextToTempFile(String text) {
        return DeckUtil.writeTextToTempFile("cbimportdeck", ".txt", text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeTextToTempFile(String filePrefix, String fileSuffix, String text) {
        BufferedWriter bw = null;
        try {
            File temp = File.createTempFile(filePrefix, fileSuffix);
            bw = new BufferedWriter(new FileWriter(temp));
            bw.write(text);
            String string = temp.getPath();
            StreamUtils.closeQuietly(bw);
            return string;
        }
        catch (IOException e) {
            logger.error((Object)"Can't write deck file to temp file", (Throwable)e);
        }
        finally {
            StreamUtils.closeQuietly(bw);
        }
        return null;
    }
}

