/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import java.util.UUID;
import java.util.regex.Pattern;
import mage.MageObject;
import mage.ObjectColor;
import mage.constants.EmptyNames;
import mage.util.CardUtil;

public final class GameLog {
    static final String LOG_COLOR_PLAYER = "#20B2AA";
    static final String LOG_COLOR_PLAYER_REQUEST = "#D2691E";
    static final String LOG_COLOR_PLAYER_CONFIRM = "#D2691E";
    static final String LOG_COLOR_GREEN = "#90EE90";
    static final String LOG_COLOR_RED = "#FF6347";
    static final String LOG_COLOR_BLUE = "#87CEFA";
    static final String LOG_COLOR_BLACK = "#696969";
    static final String LOG_COLOR_WHITE = "#F0E68C";
    static final String LOG_COLOR_MULTI = "#DAA520";
    static final String LOG_COLOR_COLORLESS = "#B0C4DE";
    static final String LOG_TT_COLOR_RED = "Red";
    static final String LOG_TT_COLOR_GREEN = "Green";
    static final String LOG_TT_COLOR_BLUE = "Blue";
    static final String LOG_TT_COLOR_BLACK = "Black";
    static final String LOG_TT_COLOR_WHITE = "#FDFFE6";
    static final String LOG_TT_COLOR_MULTI = "#A97A00";
    static final String LOG_TT_COLOR_COLORLESS = "#94A4BA";
    static final String LOG_COLOR_NEUTRAL = "#F0F8FF";

    private static String getNameForLogs(MageObject object) {
        return GameLog.getNameForLogs(object.getName());
    }

    private static String getNameForLogs(String objectName) {
        if (EmptyNames.isEmptyName(objectName)) {
            return "face down object";
        }
        return objectName;
    }

    public static String replaceNameByColoredName(MageObject mageObject, String text) {
        return GameLog.replaceNameByColoredName(mageObject, text, null);
    }

    public static String replaceNameByColoredName(MageObject mageObject, String text, MageObject alternativeObject) {
        return text.replaceAll(Pattern.quote(mageObject.getName()), GameLog.getColoredObjectIdName(mageObject, alternativeObject));
    }

    public static String getColoredObjectName(MageObject mageObject) {
        return "<font color='" + GameLog.getColorName(mageObject.getColor(null)) + "'>" + GameLog.getNameForLogs(mageObject) + "</font>";
    }

    public static String getColoredObjectIdName(MageObject mageObject) {
        return GameLog.getColoredObjectIdName(mageObject, null);
    }

    public static String getColoredObjectIdName(MageObject mageObject, MageObject alternativeObject) {
        return GameLog.getColoredObjectIdName(mageObject.getColor(null), mageObject.getId(), GameLog.getNameForLogs(mageObject), String.format("[%s]", mageObject.getId().toString().substring(0, 3)), alternativeObject == null ? null : GameLog.getNameForLogs(alternativeObject));
    }

    public static String getNeutralObjectIdName(String objectName, UUID objectId) {
        return GameLog.getColoredObjectIdName(new ObjectColor(), objectId, GameLog.getNameForLogs(objectName), String.format("[%s]", objectId.toString().substring(0, 3)), null);
    }

    public static String getColoredObjectIdName(ObjectColor color, UUID objectID, String visibleColorPart, String visibleNormalPart, String alternativeName) {
        String additionalText = !visibleColorPart.isEmpty() && !visibleNormalPart.isEmpty() ? " " : "";
        additionalText = additionalText + visibleNormalPart;
        return "<font color='" + GameLog.getColorName(color) + "' object_id='" + objectID + "'" + (alternativeName == null ? "" : " alternative_name='" + CardUtil.urlEncode(alternativeName) + "'") + ">" + visibleColorPart + "</font>" + additionalText;
    }

    public static String injectPopupSupport(String htmlLogs) {
        return htmlLogs.replaceAll("<br>", "\r\n<br>\r\n").replaceAll("<font (color=[^<]*object_id=[^>]*)>([^<]*)</font>", "<a href=\"#$2\"><font $1>$2</font></a>");
    }

    public static String getColoredObjectIdNameForTooltip(MageObject mageObject) {
        return GameLog.getColoredObjectIdNameForTooltip(mageObject.getColor(null), mageObject.getIdName());
    }

    public static String getColoredObjectIdNameForTooltip(ObjectColor color, String idName) {
        return "<font color='" + GameLog.getTooltipColorName(color) + "'>" + idName + "</font>";
    }

    public static String getNeutralColoredText(String text) {
        return "<font color='#F0F8FF'>" + text + "</font>";
    }

    public static String getColoredPlayerName(String name) {
        return "<font color='#20B2AA'>" + name + "</font>";
    }

    public static String getPlayerRequestColoredText(String name) {
        return "<font color='#D2691E'>" + name + "</font>";
    }

    public static String getPlayerConfirmColoredText(String name) {
        return "<font color='#D2691E'>" + name + "</font>";
    }

    private static String getColorName(ObjectColor objectColor) {
        if (objectColor.isMulticolored()) {
            return LOG_COLOR_MULTI;
        }
        if (objectColor.isColorless()) {
            return LOG_COLOR_COLORLESS;
        }
        if (objectColor.isRed()) {
            return LOG_COLOR_RED;
        }
        if (objectColor.isGreen()) {
            return LOG_COLOR_GREEN;
        }
        if (objectColor.isBlue()) {
            return LOG_COLOR_BLUE;
        }
        if (objectColor.isWhite()) {
            return LOG_COLOR_WHITE;
        }
        return LOG_COLOR_BLACK;
    }

    private static String getTooltipColorName(ObjectColor objectColor) {
        if (objectColor.isMulticolored()) {
            return LOG_TT_COLOR_MULTI;
        }
        if (objectColor.isColorless()) {
            return LOG_TT_COLOR_COLORLESS;
        }
        if (objectColor.isRed()) {
            return LOG_TT_COLOR_RED;
        }
        if (objectColor.isGreen()) {
            return LOG_TT_COLOR_GREEN;
        }
        if (objectColor.isBlue()) {
            return LOG_TT_COLOR_BLUE;
        }
        if (objectColor.isWhite()) {
            return LOG_TT_COLOR_WHITE;
        }
        return LOG_TT_COLOR_BLACK;
    }
}

