/*
 * Decompiled with CFR 0.152.
 */
package mage.util;

import java.net.URL;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.log4j.Logger;

public class JarVersion {
    private static final Logger logger = Logger.getLogger(JarVersion.class);
    public static final String JAR_BUILD_TIME_FROM_CLASSES = "runtime";
    private static final String JAR_BUILD_TIME_ERROR = "n/a";

    public static String getBuildTime(Class clazz) {
        String resultFormat = "uuuu-MM-dd HH:mm";
        String className = clazz.getSimpleName() + ".class";
        String classPath = clazz.getResource(className).toString();
        if (!classPath.startsWith("jar")) {
            return JAR_BUILD_TIME_FROM_CLASSES;
        }
        String manifestPath = classPath.substring(0, classPath.lastIndexOf(33) + 1) + "/META-INF/MANIFEST.MF";
        try {
            Manifest manifest = new Manifest(new URL(manifestPath).openStream());
            Attributes attr = manifest.getMainAttributes();
            String buildTime = attr.getValue("Build-Time");
            DateTimeFormatter sourceFormatter = DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneOffset.UTC);
            TemporalAccessor ta = sourceFormatter.parse(buildTime);
            DateTimeFormatter resultFormatter = DateTimeFormatter.ofPattern(resultFormat).withZone(ZoneOffset.UTC);
            return resultFormatter.format(ta);
        }
        catch (Throwable e) {
            logger.error((Object)("Can't read build time in jar manifest for class " + clazz.getName() + " and path " + manifestPath), e);
            return JAR_BUILD_TIME_ERROR;
        }
    }

    public static boolean isBuildTimeOk(String buildTime) {
        return buildTime != null && !buildTime.isEmpty() && !buildTime.equals(JAR_BUILD_TIME_ERROR) && !buildTime.equals(JAR_BUILD_TIME_FROM_CLASSES);
    }
}

