/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.util.CardUtil;
import org.apache.log4j.Logger;

public abstract class Watcher
implements Serializable {
    private static final Logger logger = Logger.getLogger(Watcher.class);
    protected UUID controllerId;
    protected UUID sourceId;
    protected boolean condition;
    protected final WatcherScope scope;

    public Watcher(WatcherScope scope) {
        this.scope = scope;
    }

    protected Watcher(Watcher watcher) {
        this.condition = watcher.condition;
        this.controllerId = watcher.controllerId;
        this.sourceId = watcher.sourceId;
        this.scope = watcher.scope;
    }

    public UUID getControllerId() {
        return this.controllerId;
    }

    public void setControllerId(UUID controllerId) {
        this.controllerId = controllerId;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public String getKey() {
        switch (this.scope) {
            case GAME: {
                return this.getBasicKey();
            }
            case PLAYER: {
                return this.controllerId + this.getBasicKey();
            }
            case CARD: {
                return this.sourceId + this.getBasicKey();
            }
        }
        throw new IllegalArgumentException("Unknown watcher scope: " + this.getClass().getSimpleName() + " - " + (Object)((Object)this.scope));
    }

    public boolean conditionMet() {
        return this.condition;
    }

    public void reset() {
        this.condition = false;
    }

    protected String getBasicKey() {
        return this.getClass().getSimpleName();
    }

    public abstract void watch(GameEvent var1, Game var2);

    public <T extends Watcher> T copy() {
        try {
            List<Constructor<?>> constructors = Arrays.asList(this.getClass().getDeclaredConstructors());
            if (constructors.size() > 1) {
                logger.error((Object)(this.getClass().getSimpleName() + " has multiple constructors"));
                return null;
            }
            Constructor<?> constructor = constructors.get(0);
            constructor.setAccessible(true);
            Object[] args = new Object[constructor.getParameterCount()];
            for (int index = 0; index < constructor.getParameterTypes().length; ++index) {
                Class<?> parameterType = constructor.getParameterTypes()[index];
                if (parameterType.isPrimitive()) {
                    if (!parameterType.getSimpleName().equalsIgnoreCase("boolean")) continue;
                    args[index] = false;
                    continue;
                }
                args[index] = null;
            }
            Watcher watcher = (Watcher)constructor.newInstance(args);
            ArrayList<Field> allFields = new ArrayList<Field>();
            allFields.addAll(Arrays.asList(this.getClass().getDeclaredFields()));
            allFields.addAll(Arrays.asList(this.getClass().getSuperclass().getDeclaredFields()));
            for (Field field : allFields) {
                if (Modifier.isStatic(field.getModifiers())) continue;
                field.setAccessible(true);
                field.set(watcher, CardUtil.deepCopyObject(field.get(this)));
            }
            return (T)watcher;
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            logger.error((Object)("Can't copy watcher: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    public WatcherScope getScope() {
        return this.scope;
    }
}

