/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class BlockedByOnlyOneCreatureThisCombatWatcher
extends Watcher {
    private final Map<CombatGroup, UUID> blockedByOneCreature = new HashMap<CombatGroup, UUID>();

    public BlockedByOnlyOneCreatureThisCombatWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        CombatGroup combatGroup;
        if (event.getType() == GameEvent.EventType.BEGIN_COMBAT_STEP_PRE) {
            this.blockedByOneCreature.clear();
        } else if (event.getType() == GameEvent.EventType.BLOCKER_DECLARED && (combatGroup = game.getCombat().findGroup(event.getTargetId())) != null) {
            if (combatGroup.getBlockers().size() == 1) {
                if (!this.blockedByOneCreature.containsKey(combatGroup)) {
                    this.blockedByOneCreature.put(combatGroup, event.getSourceId());
                } else if (!Objects.equals(this.blockedByOneCreature.get(combatGroup), event.getSourceId())) {
                    this.blockedByOneCreature.put(combatGroup, null);
                }
            } else if (combatGroup.getBlockers().size() > 1) {
                this.blockedByOneCreature.put(combatGroup, null);
            }
        }
    }

    public Set<CombatGroup> getBlockedOnlyByCreature(UUID creature) {
        HashSet<CombatGroup> combatGroups = new HashSet<CombatGroup>();
        for (Map.Entry<CombatGroup, UUID> entry : this.blockedByOneCreature.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().equals(creature)) continue;
            combatGroups.add(entry.getKey());
        }
        if (combatGroups.size() > 0) {
            return combatGroups;
        }
        return null;
    }
}

