/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class CardsCycledOrDiscardedThisTurnWatcher
extends Watcher {
    private final Map<UUID, Cards> cycledOrDiscardedCardsThisTurn = new HashMap<UUID, Cards>();
    private final Map<UUID, Set<MageObjectReference>> numberOfCycledOrDiscardedCardsThisTurn = new HashMap<UUID, Set<MageObjectReference>>();

    public CardsCycledOrDiscardedThisTurnWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Card card;
        if ((event.getType() == GameEvent.EventType.DISCARDED_CARD || event.getType() == GameEvent.EventType.CYCLED_CARD && event.getPlayerId() != null) && (card = game.getCard(event.getTargetId())) != null) {
            Cards c = this.getCardsCycledOrDiscardedThisTurn(event.getPlayerId());
            c.add(card);
            this.cycledOrDiscardedCardsThisTurn.put(event.getPlayerId(), c);
            Set<MageObjectReference> cycledOrDiscardedCards = this.numberOfCycledOrDiscardedCardsThisTurn.get(event.getPlayerId());
            if (cycledOrDiscardedCards == null) {
                cycledOrDiscardedCards = new HashSet<MageObjectReference>();
                this.numberOfCycledOrDiscardedCardsThisTurn.put(event.getPlayerId(), cycledOrDiscardedCards);
            }
            cycledOrDiscardedCards.add(new MageObjectReference(card, game));
        }
    }

    public Cards getCardsCycledOrDiscardedThisTurn(UUID playerId) {
        return this.cycledOrDiscardedCardsThisTurn.getOrDefault(playerId, new CardsImpl());
    }

    public int getNumberOfCardsCycledOrDiscardedThisTurn(UUID playerId) {
        if (this.numberOfCycledOrDiscardedCardsThisTurn.containsKey(playerId)) {
            return this.numberOfCycledOrDiscardedCardsThisTurn.get(playerId).size();
        }
        return 0;
    }

    @Override
    public void reset() {
        super.reset();
        this.cycledOrDiscardedCardsThisTurn.clear();
        this.numberOfCycledOrDiscardedCardsThisTurn.clear();
    }
}

