/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.watchers.Watcher;

public class CardsLeftGraveyardWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> cardsLeftGraveyardThisTurn = new HashMap<UUID, Set<UUID>>();

    public CardsLeftGraveyardWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE || ((ZoneChangeEvent)event).getFromZone() != Zone.GRAVEYARD) {
            return;
        }
        Card card = game.getCard(event.getTargetId());
        if (card == null) {
            return;
        }
        UUID playerId = card.getOwnerId();
        if (playerId == null) {
            return;
        }
        this.cardsLeftGraveyardThisTurn.computeIfAbsent(playerId, k -> new HashSet()).add(event.getTargetId());
    }

    public Set<Card> getCardsThatLeftGraveyard(UUID playerId, Game game) {
        return this.cardsLeftGraveyardThisTurn.getOrDefault(playerId, Collections.emptySet()).stream().map(game::getCard).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void reset() {
        super.reset();
        this.cardsLeftGraveyardThisTurn.clear();
    }
}

