/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.turn.Step;
import mage.watchers.Watcher;

public class CastFromHandWatcher
extends Watcher {
    private final Set<UUID> spellsCastFromHand = new HashSet<UUID>();
    private Step step;

    public CastFromHandWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (this.step != null && !Objects.equals(game.getTurn().getStep(), this.step)) {
            this.spellsCastFromHand.clear();
            this.step = null;
        }
        if (event.getType() == GameEvent.EventType.SPELL_CAST && event.getZone() == Zone.HAND) {
            Spell spell;
            if (this.step == null) {
                this.step = game.getTurn().getStep();
            }
            if ((spell = (Spell)game.getObject(event.getTargetId())) != null) {
                this.spellsCastFromHand.add(spell.getSourceId());
            }
        }
    }

    public boolean spellWasCastFromHand(UUID sourceId) {
        return this.spellsCastFromHand.contains(sourceId);
    }

    @Override
    public void reset() {
        super.reset();
        this.spellsCastFromHand.clear();
    }
}

