/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class CastSpellLastTurnWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfSpellsCastOnPrevTurn = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> amountOfSpellsCastOnCurrentTurn = new HashMap<UUID, Integer>();
    private final List<MageObjectReference> spellsCastThisTurnInOrder = new ArrayList<MageObjectReference>();
    private int activePlayerPrevTurnCount = 0;
    private int activePlayerThisTurnCount = 0;

    public CastSpellLastTurnWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.SPELL_CAST) {
            this.spellsCastThisTurnInOrder.add(new MageObjectReference(event.getTargetId(), game));
            UUID playerId = event.getPlayerId();
            if (playerId != null) {
                this.amountOfSpellsCastOnCurrentTurn.putIfAbsent(playerId, 0);
                this.amountOfSpellsCastOnCurrentTurn.compute(playerId, (k, a) -> a + 1);
            }
            if (game.isActivePlayer(playerId)) {
                ++this.activePlayerThisTurnCount;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.amountOfSpellsCastOnPrevTurn.clear();
        this.amountOfSpellsCastOnPrevTurn.putAll(this.amountOfSpellsCastOnCurrentTurn);
        this.amountOfSpellsCastOnCurrentTurn.clear();
        this.spellsCastThisTurnInOrder.clear();
        this.activePlayerPrevTurnCount = this.activePlayerThisTurnCount;
        this.activePlayerThisTurnCount = 0;
    }

    public Map<UUID, Integer> getAmountOfSpellsCastOnPrevTurn() {
        return this.amountOfSpellsCastOnPrevTurn;
    }

    public Map<UUID, Integer> getAmountOfSpellsCastOnCurrentTurn() {
        return this.amountOfSpellsCastOnCurrentTurn;
    }

    public int getAmountOfSpellsAllPlayersCastOnCurrentTurn() {
        return this.amountOfSpellsCastOnCurrentTurn.values().stream().mapToInt(x -> x).sum();
    }

    public int getAmountOfSpellsPlayerCastOnCurrentTurn(UUID playerId) {
        return this.amountOfSpellsCastOnCurrentTurn.getOrDefault(playerId, 0);
    }

    public int getSpellOrder(MageObjectReference spell, Game game) {
        int index = 0;
        for (MageObjectReference mor : this.spellsCastThisTurnInOrder) {
            ++index;
            if (!mor.equals(spell)) continue;
            return index;
        }
        return 0;
    }

    public int getActivePlayerPrevTurnCount() {
        return this.activePlayerPrevTurnCount;
    }

    public int getActivePlayerThisTurnCount() {
        return this.activePlayerThisTurnCount;
    }
}

