/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.cards.Card;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.Watcher;
import mage.watchers.common.CommanderPlaysCountWatcher;

public class CommanderInfoWatcher
extends Watcher {
    private final Map<UUID, Integer> damageToPlayer = new HashMap<UUID, Integer>();
    private final boolean checkCommanderDamage;
    private final String commanderTypeName;

    public CommanderInfoWatcher(String commanderTypeName, UUID commander, boolean checkCommanderDamage) {
        super(WatcherScope.CARD);
        this.sourceId = commander;
        this.checkCommanderDamage = checkCommanderDamage;
        this.commanderTypeName = commanderTypeName;
    }

    @Override
    public void watch(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent;
        if (this.checkCommanderDamage && event.getType() == GameEvent.EventType.DAMAGED_PLAYER && event instanceof DamagedPlayerEvent && this.sourceId.equals(event.getSourceId()) && (damageEvent = (DamagedPlayerEvent)event).isCombatDamage()) {
            UUID playerUUID = event.getTargetId();
            Integer damage = this.damageToPlayer.getOrDefault(playerUUID, 0);
            damage = damage + damageEvent.getAmount();
            this.damageToPlayer.put(playerUUID, damage);
            Player player = game.getPlayer(playerUUID);
            MageObject commander = game.getObject(this.sourceId);
            if (player != null && commander != null) {
                if (!game.isSimulation()) {
                    game.informPlayers(commander.getLogName() + " did " + damage + " combat damage to " + player.getLogName() + " during the game.");
                }
                this.addCardInfoToCommander(game);
            }
        }
        if (event.getType() == GameEvent.EventType.ZONE_CHANGE && event.getTargetId().equals(this.sourceId)) {
            this.addCardInfoToCommander(game);
        }
    }

    public void addCardInfoToCommander(Game game) {
        Card object = game.getPermanent(this.sourceId);
        if (object == null) {
            object = game.getCard(this.sourceId);
        }
        if (object != null) {
            StringBuilder sb = new StringBuilder();
            sb.append("<b>").append(this.commanderTypeName).append("</b>");
            CommanderPlaysCountWatcher watcher = game.getState().getWatcher(CommanderPlaysCountWatcher.class);
            int playsCount = watcher.getPlaysCount(this.sourceId);
            if (playsCount > 0) {
                sb.append(' ').append(playsCount).append(playsCount == 1 ? " time" : " times").append(" played from the command zone.");
            }
            this.addInfoToObject(object, "Commander", sb.toString(), game);
            if (this.checkCommanderDamage) {
                for (Map.Entry<UUID, Integer> entry : this.damageToPlayer.entrySet()) {
                    Player damagedPlayer = game.getPlayer(entry.getKey());
                    sb.append("<b>").append(this.commanderTypeName).append("</b> did ").append(entry.getValue()).append(" combat damage to player ").append(damagedPlayer.getLogName()).append('.');
                    this.addInfoToObject(object, "Commander" + entry.getKey(), "<b>" + this.commanderTypeName + "</b> did " + entry.getValue() + " combat damage to player " + damagedPlayer.getLogName() + '.', game);
                }
            }
        }
    }

    private void addInfoToObject(MageObject object, String key, String value, Game game) {
        ((Card)object).addInfo(key, value, game);
        if (object instanceof Permanent) {
            ((Permanent)object).addInfo(key, value, game);
        }
    }

    public Map<UUID, Integer> getDamageToPlayer() {
        return this.damageToPlayer;
    }
}

