/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

public class CreatedTokenWatcher
extends Watcher {
    private final Map<UUID, Integer> playerMap = new HashMap<UUID, Integer>();
    private final Map<UUID, Map<SubType, Integer>> tokenCreatedMap = new HashMap<UUID, Map<SubType, Integer>>();

    public CreatedTokenWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.CREATED_TOKEN) {
            this.playerMap.compute(event.getPlayerId(), CardUtil::setOrIncrementValue);
            this.tokenCreatedMap.putIfAbsent(event.getPlayerId(), new HashMap());
            Permanent token = game.getPermanentOrLKIBattlefield(event.getTargetId());
            if (token == null) {
                throw new IllegalStateException("Wrong code usage: found created token event, but can't find a real token in battlefield or lki");
            }
            Map playersTokens = this.tokenCreatedMap.getOrDefault(event.getPlayerId(), new EnumMap(SubType.class));
            for (SubType subType : token.getSubtype(game)) {
                playersTokens.compute(subType, CardUtil::setOrIncrementValue);
            }
            this.tokenCreatedMap.put(event.getPlayerId(), playersTokens);
        }
    }

    @Override
    public void reset() {
        this.playerMap.clear();
        this.tokenCreatedMap.clear();
    }

    public static boolean checkPlayer(UUID playerId, Game game) {
        return CreatedTokenWatcher.getPlayerCount(playerId, game) > 0;
    }

    public static int getPlayerCount(UUID playerId, Game game) {
        return game.getState().getWatcher(CreatedTokenWatcher.class).playerMap.getOrDefault(playerId, 0);
    }

    public static int getTypeCreatedCountByPlayer(UUID playerId, SubType tokenType, Game game) {
        return ((Map)game.getState().getWatcher(CreatedTokenWatcher.class).tokenCreatedMap.getOrDefault(playerId, new EnumMap(SubType.class))).getOrDefault((Object)tokenType, 0);
    }
}

