/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class CreatureAttackedWhichPlayerWatcher
extends Watcher {
    private final Map<UUID, UUID> getPlayerAttackedThisTurnByCreature = new HashMap<UUID, UUID>();

    public CreatureAttackedWhichPlayerWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ATTACKER_DECLARED) {
            UUID creatureId = event.getSourceId();
            UUID playerId = event.getTargetId();
            if (playerId != null && creatureId != null) {
                this.getPlayerAttackedThisTurnByCreature.putIfAbsent(creatureId, playerId);
            }
        }
    }

    public UUID getPlayerAttackedThisTurnByCreature(UUID creatureId) {
        return this.getPlayerAttackedThisTurnByCreature.getOrDefault(creatureId, null);
    }

    @Override
    public void reset() {
        super.reset();
        this.getPlayerAttackedThisTurnByCreature.clear();
    }
}

