/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

public class DamagedPlayerThisCombatWatcher
extends Watcher {
    private final Map<UUID, List<MageObjectReference>> permanents = new HashMap<UUID, List<MageObjectReference>>();
    private final Map<MageObjectReference, UUID> damageTarget = new HashMap<MageObjectReference, UUID>();

    public DamagedPlayerThisCombatWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.COMBAT_DAMAGE_STEP_POST || event.getType() == GameEvent.EventType.CLEANUP_STEP_POST) {
            this.permanents.clear();
            this.damageTarget.clear();
            return;
        }
        if (event.getType() != GameEvent.EventType.DAMAGED_PLAYER || !((DamagedPlayerEvent)event).isCombatDamage()) {
            return;
        }
        Permanent creature = game.getPermanent(event.getSourceId());
        if (creature == null) {
            return;
        }
        MageObjectReference mor = new MageObjectReference(creature, game);
        this.damageTarget.put(mor, event.getPlayerId());
        List list = this.permanents.computeIfAbsent(creature.getControllerId(), key -> new ArrayList());
        list.add(mor);
    }

    public Set<MageObjectReference> getPermanents(UUID controllerID, UUID damagedPlayerID) {
        return this.permanents.getOrDefault(controllerID, Collections.emptyList()).stream().filter(mor -> damagedPlayerID.equals(this.damageTarget.get(mor))).collect(Collectors.toSet());
    }
}

