/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

public class EnergySpentOrLostWatcher
extends Watcher {
    private final Map<UUID, Integer> energyLostOrSpent = new HashMap<UUID, Integer>();

    public EnergySpentOrLostWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.COUNTERS_REMOVED) {
            return;
        }
        if (!event.getData().equals(CounterType.ENERGY.getName())) {
            return;
        }
        int amount = event.getAmount();
        if (amount <= 0) {
            return;
        }
        this.energyLostOrSpent.compute(event.getTargetId(), (k, i) -> i == null ? amount : Integer.sum(i, amount));
    }

    @Override
    public void reset() {
        super.reset();
        this.energyLostOrSpent.clear();
    }

    public static int getAmountEnergyLostOrSpentThisTurn(Game game, UUID playerId) {
        EnergySpentOrLostWatcher watcher = game.getState().getWatcher(EnergySpentOrLostWatcher.class);
        return watcher == null ? 0 : watcher.energyLostOrSpent.getOrDefault(playerId, 0);
    }
}

