/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

public class FirstSpellCastThisTurnWatcher
extends Watcher {
    private final Map<UUID, UUID> playerFirstSpellCast = new HashMap<UUID, UUID>();
    private final Map<UUID, UUID> playerFirstCastSpell = new HashMap<UUID, UUID>();

    public FirstSpellCastThisTurnWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case SPELL_CAST: 
            case CAST_SPELL: {
                Spell spell = (Spell)game.getObject(event.getTargetId());
                if (spell == null || this.playerFirstSpellCast.containsKey(spell.getControllerId())) break;
                if (event.getType() == GameEvent.EventType.SPELL_CAST) {
                    this.playerFirstSpellCast.put(spell.getControllerId(), spell.getId());
                    break;
                }
                if (event.getType() != GameEvent.EventType.CAST_SPELL) break;
                this.playerFirstCastSpell.put(spell.getControllerId(), spell.getId());
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.playerFirstSpellCast.clear();
        this.playerFirstCastSpell.clear();
    }

    public UUID getIdOfFirstCastSpell(UUID playerId) {
        return this.playerFirstSpellCast.getOrDefault(playerId, this.playerFirstCastSpell.get(playerId));
    }
}

