/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ManaPaidEvent;
import mage.watchers.Watcher;

public class ManaPaidObjectSourceWatcher
extends Watcher {
    private final Map<MageObjectReference, Set<MageObjectReference>> payMap = new HashMap<MageObjectReference, Set<MageObjectReference>>();

    public ManaPaidObjectSourceWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.MANA_PAID) {
            return;
        }
        ManaPaidEvent manaEvent = (ManaPaidEvent)event;
        UUID paid = manaEvent.getSourcePaidId();
        MageObject sourceObject = manaEvent.getSourceObject();
        if (paid == null || sourceObject == null) {
            return;
        }
        this.payMap.computeIfAbsent(new MageObjectReference(paid, game), x -> new HashSet()).add(new MageObjectReference(sourceObject, game));
    }

    public boolean checkManaFromSourceWasUsedToPay(MageObjectReference sourceOfMana, MageObjectReference paidObject) {
        return this.payMap.getOrDefault(paidObject, Collections.emptySet()).contains(sourceOfMana);
    }

    @Override
    public void reset() {
        this.payMap.clear();
        super.reset();
    }
}

