/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import mage.MageObjectReference;
import mage.Mana;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

public class ManaSpentToCastWatcher
extends Watcher {
    private final Map<MageObjectReference, Mana> manaMap = new HashMap<MageObjectReference, Mana>();

    public ManaSpentToCastWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = (Spell)game.getObject(event.getTargetId())) != null) {
            this.manaMap.put(new MageObjectReference(spell.getSpellAbility()), spell.getSpellAbility().getManaCostsToPay().getUsedManaToPay());
        }
    }

    public Mana getManaPayment(MageObjectReference source) {
        return this.manaMap.getOrDefault(source, null);
    }

    @Override
    public void reset() {
        super.reset();
        this.manaMap.clear();
    }
}

