/*
 * Decompiled with CFR 0.152.
 */
package mage.watchers.common;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.keyword.MiracleAbility;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.players.Player;
import mage.watchers.Watcher;

public class MiracleWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfCardsDrawnThisTurn = new HashMap<UUID, Integer>();

    public MiracleWatcher() {
        super(WatcherScope.GAME);
    }

    @Override
    public void watch(GameEvent event, Game game) {
        UUID playerId;
        if (event.getType() == GameEvent.EventType.UNTAP_STEP_PRE) {
            this.reset();
        }
        if (game.getPhase() != null && event.getType() == GameEvent.EventType.DREW_CARD && (playerId = event.getPlayerId()) != null) {
            int amount = 1 + this.amountOfCardsDrawnThisTurn.getOrDefault(playerId, 0);
            this.amountOfCardsDrawnThisTurn.put(playerId, amount);
            if (amount == 1) {
                this.checkMiracleAbility(event, game);
            }
        }
    }

    private void checkMiracleAbility(GameEvent event, Game game) {
        Card card = game.getCard(event.getTargetId());
        if (card != null) {
            for (Ability ability : card.getAbilities(game)) {
                Player controller;
                if (!(ability instanceof MiracleAbility) || (controller = game.getPlayer(ability.getControllerId())) == null) continue;
                CardsImpl cards = new CardsImpl(card);
                controller.lookAtCards("Miracle", cards, game);
                if (!controller.chooseUse(Outcome.Benefit, "Reveal " + card.getLogName() + " to be able to use Miracle?", ability, game)) continue;
                controller.revealCards("Miracle", (Cards)cards, game);
                game.fireEvent(GameEvent.getEvent(GameEvent.EventType.MIRACLE_CARD_REVEALED, card.getId(), ability, controller.getId()));
                break;
            }
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.amountOfCardsDrawnThisTurn.clear();
    }
}

